/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.animation;

import android.support.constraint.solver.widgets.ConstraintWidget;
import com.android.tools.sherpa.animation.Animation;
import com.android.tools.sherpa.drawing.ViewTransform;
import com.android.tools.sherpa.interaction.ConstraintHandle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class AnimatedLine
extends Animation {
    private ConstraintHandle mConstraintHandle;
    protected Color mColor = Color.white;
    private Rectangle mBounds = new Rectangle();

    public AnimatedLine(ConstraintHandle anchor) {
        this.mConstraintHandle = anchor;
        ConstraintWidget widget = this.mConstraintHandle.getOwner();
        int l = widget.getDrawX();
        int t = widget.getDrawY();
        int w = widget.getDrawWidth();
        int h = widget.getDrawHeight();
        switch (this.mConstraintHandle.getAnchor().getType()) {
            case LEFT: {
                this.mBounds.setBounds(l, t, 0, h);
                break;
            }
            case RIGHT: {
                this.mBounds.setBounds(l + w, t, 0, h);
                break;
            }
            case TOP: {
                this.mBounds.setBounds(l, t, w, 0);
                break;
            }
            case BOTTOM: {
                this.mBounds.setBounds(l, t + h, w, 0);
                break;
            }
            case BASELINE: {
                this.mBounds.setBounds(l, t + widget.getBaselineDistance(), w, 0);
            }
        }
        this.setLoop(true);
    }

    @Override
    public void onPaint(ViewTransform transform, Graphics2D g) {
        int x = transform.getSwingX(this.mBounds.x);
        int y = transform.getSwingY(this.mBounds.y);
        int w = transform.getSwingDimension(this.mBounds.width);
        int h = transform.getSwingDimension(this.mBounds.height);
        double progress = this.getProgress();
        int alpha = this.getPulsatingAlpha(progress);
        Color highlight = new Color(this.mColor.getRed(), this.mColor.getGreen(), this.mColor.getBlue(), alpha);
        g.setColor(highlight);
        int extra = this.getExtra(progress);
        g.fillRect(x - extra, y - extra, w + 2 * extra + 1, h + 2 * extra + 1);
    }

    protected int getExtra(double progress) {
        return 0;
    }
}

