/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.dependencies.beans;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.seam.dependencies.beans.SeamComponentNodeInfo;
import com.intellij.seam.model.xml.components.SeamDomComponent;
import icons.SeamIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SeamDomComponentNodeInfo
implements SeamComponentNodeInfo<SeamDomComponent> {
    private final SeamDomComponent myComponent;

    public SeamDomComponentNodeInfo(@NotNull SeamDomComponent component) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/seam/dependencies/beans/SeamDomComponentNodeInfo", "<init>"));
        }
        this.myComponent = component;
    }

    @Override
    @NonNls
    public String getName() {
        if (!this.myComponent.isValid()) {
            return "";
        }
        String name = this.myComponent.getComponentName();
        return StringUtil.isEmptyOrSpaces((String)name) ? "Noname" : name;
    }

    @Override
    public Icon getIcon() {
        return SeamIcons.Seam;
    }

    @Override
    @NotNull
    public SeamDomComponent getIdentifyingElement() {
        SeamDomComponent seamDomComponent = this.myComponent;
        if (seamDomComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/dependencies/beans/SeamDomComponentNodeInfo", "getIdentifyingElement"));
        }
        return seamDomComponent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeamDomComponentNodeInfo nodeInfo = (SeamDomComponentNodeInfo)o;
        return !(this.myComponent != null && this.myComponent.isValid() && nodeInfo.myComponent.isValid() ? !this.myComponent.equals(nodeInfo.myComponent) : nodeInfo.myComponent != null);
    }

    public int hashCode() {
        return this.myComponent != null && this.myComponent.isValid() ? this.myComponent.hashCode() : 0;
    }
}

