/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.plugins.drools.lang.psi;

import com.intellij.ide.presentation.Presentation;
import com.intellij.lang.Language;
import com.intellij.plugins.drools.DroolsLanguage;
import com.intellij.plugins.drools.lang.psi.DroolsFunctionStatement;
import com.intellij.plugins.drools.lang.psi.DroolsLightParameter;
import com.intellij.plugins.drools.lang.psi.DroolsParameter;
import com.intellij.plugins.drools.lang.psi.DroolsParameters;
import com.intellij.plugins.drools.lang.psi.DroolsType;
import com.intellij.plugins.drools.lang.psi.util.DroolsResolveUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.light.LightMethodBuilder;
import org.jetbrains.annotations.NotNull;

@Presentation(typeName="Function", icon="AllIcons.Nodes.Method")
public class DroolsFunctionLightMethodBuilder
extends LightMethodBuilder {
    private final DroolsFunctionStatement myFunction;

    public DroolsFunctionLightMethodBuilder(@NotNull DroolsFunctionStatement function) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "com/intellij/plugins/drools/lang/psi/DroolsFunctionLightMethodBuilder", "<init>"));
        }
        super(function.getManager(), (Language)DroolsLanguage.INSTANCE, function.getFunctionName());
        this.myFunction = function;
        this.init(this.myFunction);
    }

    private void init(DroolsFunctionStatement function) {
        DroolsParameters parameters;
        DroolsType type = function.getType();
        if (type != null) {
            this.setMethodReturnType(type.getText());
        }
        if ((parameters = function.getParameters()) != null) {
            for (DroolsParameter droolsParameter : parameters.getParameterList()) {
                this.addParameter(this.createParameter(droolsParameter));
            }
        }
    }

    @NotNull
    private PsiParameter createParameter(@NotNull DroolsParameter droolsParameter) {
        if (droolsParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "droolsParameter", "com/intellij/plugins/drools/lang/psi/DroolsFunctionLightMethodBuilder", "createParameter"));
        }
        String paramName = droolsParameter.getIdentifier().getText();
        PsiType psiType = DroolsResolveUtil.resolveType(droolsParameter.getType());
        DroolsLightParameter parameter = psiType == null ? new DroolsLightParameter(droolsParameter, paramName, (PsiType)PsiType.NULL, (PsiElement)this) : new DroolsLightParameter(droolsParameter, paramName, psiType, (PsiElement)this);
        parameter.setNavigationElement((PsiElement)droolsParameter);
        DroolsLightParameter droolsLightParameter = parameter;
        if (droolsLightParameter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/DroolsFunctionLightMethodBuilder", "createParameter"));
        }
        return droolsLightParameter;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        DroolsFunctionStatement droolsFunctionStatement = this.myFunction;
        if (droolsFunctionStatement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/plugins/drools/lang/psi/DroolsFunctionLightMethodBuilder", "getNavigationElement"));
        }
        return droolsFunctionStatement;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        DroolsFunctionLightMethodBuilder builder = (DroolsFunctionLightMethodBuilder)((Object)o);
        return this.myFunction.equals(builder.myFunction);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myFunction.hashCode();
        return result;
    }
}

