/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SortedSet;
import org.gradle.api.internal.tasks.TaskFilePropertySpec;
import org.gradle.api.internal.tasks.TaskPropertySpec;
import org.gradle.api.tasks.TaskPropertyBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskPropertyUtils {
    public static <T extends TaskFilePropertySpec> SortedSet<T> collectFileProperties(String displayName, Iterator<? extends T> fileProperties) {
        HashSet names = Sets.newHashSet();
        ImmutableSortedSet.Builder builder = ImmutableSortedSet.naturalOrder();
        while (fileProperties.hasNext()) {
            TaskFilePropertySpec propertySpec = (TaskFilePropertySpec)fileProperties.next();
            String propertyName = propertySpec.getPropertyName();
            if (!names.add(propertyName)) {
                throw new IllegalArgumentException(String.format("Multiple %s file properties with name '%s'", displayName, propertyName));
            }
            builder.add((Object)propertySpec);
        }
        return builder.build();
    }

    public static <T extends TaskPropertySpec & TaskPropertyBuilder> void ensurePropertiesHaveNames(Iterable<T> properties) {
        int unnamedPropertyCounter = 0;
        for (TaskPropertySpec propertySpec : properties) {
            String propertyName = propertySpec.getPropertyName();
            if (propertyName != null) continue;
            propertyName = "$" + ++unnamedPropertyCounter;
            ((TaskPropertyBuilder)((Object)propertySpec)).withPropertyName(propertyName);
        }
    }
}

