/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal;

import com.google.common.io.Closer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.gradle.api.UncheckedIOException;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.caching.BuildCache;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.internal.Factory;

public class LocalDirectoryBuildCache
implements BuildCache {
    private final PersistentCache persistentCache;

    public LocalDirectoryBuildCache(CacheRepository cacheRepository, File directory) {
        this(cacheRepository.cache(LocalDirectoryBuildCache.checkDirectory(directory)));
    }

    public LocalDirectoryBuildCache(CacheRepository cacheRepository, String cacheKey) {
        this(cacheRepository.cache(cacheKey));
    }

    private LocalDirectoryBuildCache(CacheBuilder cacheBuilder) {
        this.persistentCache = cacheBuilder.withDisplayName("Build cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).open();
    }

    private static File checkDirectory(File directory) {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be a directory", directory));
            }
            if (!directory.canRead()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be readable", directory));
            }
            if (!directory.canWrite()) {
                throw new IllegalArgumentException(String.format("Cache directory %s must be writable", directory));
            }
        } else if (!directory.mkdirs()) {
            throw new UncheckedIOException(String.format("Could not create cache directory: %s", directory));
        }
        return directory;
    }

    public boolean load(final BuildCacheKey key, final BuildCacheEntryReader reader) throws BuildCacheException {
        return this.persistentCache.useCache("load build cache entry", new Factory<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Boolean create() {
                File file = LocalDirectoryBuildCache.this.getFile(key.getHashCode());
                if (file.isFile()) {
                    Boolean bl;
                    Closer closer = Closer.create();
                    FileInputStream stream = (FileInputStream)closer.register((Closeable)new FileInputStream(file));
                    try {
                        reader.readFrom(stream);
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        try {
                            closer.close();
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new UncheckedIOException((Throwable)ex);
                        }
                    }
                    closer.close();
                    return bl;
                }
                return false;
            }
        });
    }

    public void store(final BuildCacheKey key, final BuildCacheEntryWriter result) throws BuildCacheException {
        this.persistentCache.useCache("store build cache entry", new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                File file = LocalDirectoryBuildCache.this.getFile(key.getHashCode());
                try {
                    Closer closer = Closer.create();
                    OutputStream output = (OutputStream)closer.register((Closeable)new FileOutputStream(file));
                    try {
                        result.writeTo(output);
                    }
                    finally {
                        closer.close();
                    }
                }
                catch (IOException ex) {
                    throw new UncheckedIOException((Throwable)ex);
                }
            }
        });
    }

    private File getFile(String key) {
        return new File(this.persistentCache.getBaseDir(), key);
    }

    public String getDescription() {
        return "a local build cache (" + this.persistentCache.getBaseDir() + ")";
    }

    public void close() throws IOException {
        this.persistentCache.close();
    }
}

