/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.java_websocket.SocketChannelIOHelper;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketAdapter;
import org.java_websocket.WebSocketFactory;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WebSocketListener;
import org.java_websocket.WrappedByteChannel;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.Handshakedata;

public abstract class WebSocketServer
extends WebSocketAdapter
implements Runnable {
    public static int DECODERS = Runtime.getRuntime().availableProcessors();
    private final Set<WebSocket> connections = new HashSet<WebSocket>();
    private InetSocketAddress address;
    private ServerSocketChannel server;
    private Selector selector;
    private List<Draft> drafts;
    private Thread selectorthread;
    private List<WebSocketWorker> decoders;
    private BlockingQueue<WebSocketImpl> oqueue;
    private List<WebSocketImpl> iqueue;
    private BlockingQueue<ByteBuffer> buffers;
    private int queueinvokes = 0;
    private AtomicInteger queuesize = new AtomicInteger(0);
    private WebSocketServerFactory wsf = new WebSocketServerFactory(){

        @Override
        public WebSocketImpl createWebSocket(WebSocketAdapter a, Draft d, Socket s) {
            return new WebSocketImpl((WebSocketListener)a, d, s);
        }

        @Override
        public WebSocketImpl createWebSocket(WebSocketAdapter a, List<Draft> d, Socket s) {
            return new WebSocketImpl((WebSocketListener)a, d, s);
        }

        @Override
        public SocketChannel wrapChannel(SelectionKey c) {
            return (SocketChannel)c.channel();
        }
    };

    public WebSocketServer() throws UnknownHostException {
        this(new InetSocketAddress(80), DECODERS, null);
    }

    public WebSocketServer(InetSocketAddress address) {
        this(address, DECODERS, null);
    }

    public WebSocketServer(InetSocketAddress address, int decoders) {
        this(address, decoders, null);
    }

    public WebSocketServer(InetSocketAddress address, List<Draft> drafts) {
        this(address, DECODERS, drafts);
    }

    public WebSocketServer(InetSocketAddress address, int decodercount, List<Draft> drafts) {
        this.drafts = drafts == null ? Collections.emptyList() : drafts;
        this.setAddress(address);
        this.oqueue = new LinkedBlockingQueue<WebSocketImpl>();
        this.iqueue = new LinkedList<WebSocketImpl>();
        this.decoders = new ArrayList<WebSocketWorker>(decodercount);
        this.buffers = new LinkedBlockingQueue<ByteBuffer>();
        for (int i = 0; i < decodercount; ++i) {
            WebSocketWorker ex = new WebSocketWorker();
            this.decoders.add(ex);
            ex.start();
        }
    }

    public void start() {
        if (this.selectorthread != null) {
            throw new IllegalStateException("Already started");
        }
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws IOException {
        Set<WebSocket> set = this.connections;
        synchronized (set) {
            for (WebSocket ws : this.connections) {
                ws.close(1000);
            }
        }
        this.selectorthread.interrupt();
        this.server.close();
    }

    public Set<WebSocket> connections() {
        return this.connections;
    }

    public void setAddress(InetSocketAddress address) {
        this.address = address;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        int port = this.getAddress().getPort();
        if (port == 0 && this.server != null) {
            port = this.server.socket().getLocalPort();
        }
        return port;
    }

    public List<Draft> getDraft() {
        return Collections.unmodifiableList(this.drafts);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        if (this.selectorthread != null) {
            throw new IllegalStateException("This instance of " + this.getClass().getSimpleName() + " can only be started once the same time.");
        }
        this.selectorthread = Thread.currentThread();
        this.selectorthread.setName("WebsocketSelector" + this.selectorthread.getId());
        try {
            this.server = ServerSocketChannel.open();
            this.server.configureBlocking(false);
            ServerSocket socket = this.server.socket();
            socket.setReceiveBufferSize(WebSocket.RCVBUF);
            socket.bind(this.address);
            this.selector = Selector.open();
            this.server.register(this.selector, this.server.validOps());
        }
        catch (IOException ex) {
            this.onWebsocketError(null, ex);
            return;
        }
        try {
            block11: while (!this.selectorthread.isInterrupted()) {
                SelectionKey key = null;
                WebSocketImpl conn = null;
                try {
                    this.selector.select();
                    this.registerWrite();
                    Set<SelectionKey> keys = this.selector.selectedKeys();
                    Iterator<SelectionKey> i = keys.iterator();
                    while (i.hasNext()) {
                        block21: {
                            key = i.next();
                            if (!key.isValid()) continue;
                            if (key.isAcceptable()) {
                                SocketChannel channel = this.server.accept();
                                channel.configureBlocking(false);
                                WebSocketImpl w = this.wsf.createWebSocket((WebSocketAdapter)this, this.drafts, channel.socket());
                                w.key = channel.register(this.selector, 1, w);
                                w.channel = this.wsf.wrapChannel(w.key);
                                i.remove();
                                this.allocateBuffers(w);
                                continue;
                            }
                            if (key.isReadable()) {
                                conn = (WebSocketImpl)key.attachment();
                                ByteBuffer buf = this.takeBuffer();
                                try {
                                    if (SocketChannelIOHelper.read(buf, conn, conn.channel)) {
                                        conn.inQueue.put(buf);
                                        this.queue(conn);
                                        i.remove();
                                        if (conn.channel instanceof WrappedByteChannel && ((WrappedByteChannel)conn.channel).isNeedRead()) {
                                            this.iqueue.add(conn);
                                        }
                                        break block21;
                                    }
                                    this.pushBuffer(buf);
                                }
                                catch (IOException e) {
                                    this.pushBuffer(buf);
                                    throw e;
                                }
                                catch (RuntimeException e) {
                                    this.pushBuffer(buf);
                                    throw e;
                                }
                            }
                        }
                        if (!key.isWritable() || !SocketChannelIOHelper.batch(conn = (WebSocketImpl)key.attachment(), conn.channel) || !key.isValid()) continue;
                        key.interestOps(1);
                    }
                    while (true) {
                        if (this.iqueue.isEmpty()) continue block11;
                        conn = this.iqueue.remove(0);
                        WrappedByteChannel c = (WrappedByteChannel)conn.channel;
                        ByteBuffer buf = this.takeBuffer();
                        if (SocketChannelIOHelper.readMore(buf, conn, c)) {
                            this.iqueue.add(conn);
                        }
                        conn.inQueue.put(buf);
                        this.queue(conn);
                    }
                }
                catch (CancelledKeyException e) {
                }
                catch (IOException ex) {
                    if (key != null) {
                        key.cancel();
                    }
                    this.handleIOException(conn, ex);
                }
            }
            return;
            {
                catch (InterruptedException e) {
                    return;
                }
            }
        }
        catch (RuntimeException e) {
            this.handleFatal(null, e);
        }
    }

    protected void allocateBuffers(WebSocket c) throws InterruptedException {
        if (this.queuesize.get() >= 2 * this.decoders.size() + 1) {
            return;
        }
        this.queuesize.incrementAndGet();
        this.buffers.put(this.createBuffer());
    }

    protected void releaseBuffers(WebSocket c) throws InterruptedException {
    }

    public ByteBuffer createBuffer() {
        return ByteBuffer.allocate(WebSocket.RCVBUF);
    }

    private void queue(WebSocketImpl ws) throws InterruptedException {
        if (ws.workerThread == null) {
            ws.workerThread = this.decoders.get(this.queueinvokes % this.decoders.size());
            ++this.queueinvokes;
        }
        ws.workerThread.put(ws);
    }

    private ByteBuffer takeBuffer() throws InterruptedException {
        return this.buffers.take();
    }

    private void pushBuffer(ByteBuffer buf) throws InterruptedException {
        if (this.buffers.size() > this.queuesize.intValue()) {
            return;
        }
        this.buffers.put(buf);
    }

    private void registerWrite() throws CancelledKeyException {
        int size = this.oqueue.size();
        for (int i = 0; i < size; ++i) {
            WebSocketImpl conn = (WebSocketImpl)this.oqueue.remove();
            conn.key.interestOps(5);
        }
    }

    private void handleIOException(WebSocket conn, IOException ex) {
        this.onWebsocketError(conn, ex);
        if (conn != null) {
            conn.close(1006);
        }
    }

    private void handleFatal(WebSocket conn, RuntimeException e) {
        this.onError(conn, e);
        try {
            this.selector.close();
        }
        catch (IOException e1) {
            this.onError(null, e1);
        }
        for (WebSocketWorker w : this.decoders) {
            w.interrupt();
        }
    }

    protected String getFlashSecurityPolicy() {
        return "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"" + this.getPort() + "\" /></cross-domain-policy>";
    }

    @Override
    public final void onWebsocketMessage(WebSocket conn, String message) {
        this.onMessage(conn, message);
    }

    @Override
    public final void onWebsocketMessage(WebSocket conn, ByteBuffer blob) {
        this.onMessage(conn, blob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onWebsocketOpen(WebSocket conn, Handshakedata handshake) {
        Set<WebSocket> set = this.connections;
        synchronized (set) {
            if (this.connections.add(conn)) {
                this.onOpen(conn, (ClientHandshake)handshake);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onWebsocketClose(WebSocket conn, int code, String reason, boolean remote) {
        this.oqueue.add((WebSocketImpl)conn);
        this.selector.wakeup();
        try {
            Set<WebSocket> set = this.connections;
            synchronized (set) {
                if (this.connections.remove(conn)) {
                    this.onClose(conn, code, reason, remote);
                }
            }
        }
        finally {
            try {
                this.releaseBuffers(conn);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public final void onWebsocketError(WebSocket conn, Exception ex) {
        this.onError(conn, ex);
    }

    @Override
    public final void onWriteDemand(WebSocket w) {
        WebSocketImpl conn = (WebSocketImpl)w;
        this.oqueue.add(conn);
        this.selector.wakeup();
    }

    public final void setWebSocketFactory(WebSocketServerFactory wsf) {
        this.wsf = wsf;
    }

    public final WebSocketFactory getWebSocketFactory() {
        return this.wsf;
    }

    public abstract void onOpen(WebSocket var1, ClientHandshake var2);

    public abstract void onClose(WebSocket var1, int var2, String var3, boolean var4);

    public abstract void onMessage(WebSocket var1, String var2);

    public abstract void onError(WebSocket var1, Exception var2);

    public void onMessage(WebSocket conn, ByteBuffer message) {
    }

    static /* synthetic */ void access$000(WebSocketServer x0, WebSocket x1, IOException x2) {
        x0.handleIOException(x1, x2);
    }

    static /* synthetic */ void access$100(WebSocketServer x0, ByteBuffer x1) throws InterruptedException {
        x0.pushBuffer(x1);
    }

    static /* synthetic */ void access$200(WebSocketServer x0, WebSocket x1, RuntimeException x2) {
        x0.handleFatal(x1, x2);
    }

    public static interface WebSocketServerFactory
    extends WebSocketFactory {
        @Override
        public WebSocketImpl createWebSocket(WebSocketAdapter var1, Draft var2, Socket var3);

        @Override
        public WebSocketImpl createWebSocket(WebSocketAdapter var1, List<Draft> var2, Socket var3);

        public ByteChannel wrapChannel(SelectionKey var1) throws IOException;
    }

    public class WebSocketWorker
    extends Thread {
        private BlockingQueue<WebSocketImpl> iqueue = new LinkedBlockingQueue<WebSocketImpl>();

        public WebSocketWorker() {
            this.setName("WebSocketWorker-" + this.getId());
            this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    Thread.getDefaultUncaughtExceptionHandler().uncaughtException(t, e);
                }
            });
        }

        public void put(WebSocketImpl ws) throws InterruptedException {
            this.iqueue.put(ws);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public void run() {
            ws = null;
            try {
                while (true) lbl-1000:
                // 4 sources

                {
                    buf = null;
                    ws = this.iqueue.take();
                    buf = (ByteBuffer)ws.inQueue.poll();
                    if (!WebSocketWorker.$assertionsDisabled && buf == null) {
                        throw new AssertionError();
                    }
                    try {
                        ws.decode(buf);
                    }
                    catch (IOException e) {
                        WebSocketServer.access$000(WebSocketServer.this, ws, e);
                    }
                    finally {
                        WebSocketServer.access$100(WebSocketServer.this, buf);
                        continue;
                    }
                    break;
                }
            }
            catch (RuntimeException e) {
                WebSocketServer.access$200(WebSocketServer.this, ws, e);
            }
            catch (InterruptedException e) {
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            ** GOTO lbl-1000
        }
    }
}

