/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.deployment;

import com.intellij.icons.AllIcons;
import com.intellij.j2ee.webSphere.deployment.WebSphereDeploymentProvider;
import com.intellij.j2ee.webSphere.deploymentSource.LooseApplicationDeploymentSource;
import com.intellij.javaee.customDeployment.CustomDeploymentActionHandler;
import com.intellij.javaee.customDeployment.CustomDeploymentProvider;
import com.intellij.javaee.customDeployment.DeploymentSourcesCollection;
import com.intellij.javaee.deployment.DeploymentManager;
import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointer;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.impl.ui.ChooseArtifactsDialog;
import com.intellij.remoteServer.configuration.deployment.ArtifactDeploymentSource;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class LooseDeploymentProvider
extends CustomDeploymentProvider {
    public CustomDeploymentActionHandler createActionHandler(DeploymentSourcesCollection sources, Project project) {
        return new CustomDeploymentActionHandler("Loose applications...", AllIcons.FileTypes.Xml, project, sources){

            public boolean isAvailable() {
                return !this.getAvailableArtifacts().isEmpty();
            }

            public void run() {
                List<Artifact> supportedArtifacts = this.getAvailableArtifacts();
                if (supportedArtifacts.size() == 1) {
                    this.addArtifact(supportedArtifacts.get(0));
                    return;
                }
                ChooseArtifactsDialog dialog = new ChooseArtifactsDialog(this.getProject(), supportedArtifacts, "Select Artifacts to Deploy as Loose Applications", "Selected artifacts will be deployed at server startup as loose applications");
                if (dialog.showAndGet()) {
                    List chosen = dialog.getChosenElements();
                    for (Artifact artifact : chosen) {
                        this.addArtifact(artifact);
                    }
                }
            }

            private void addArtifact(Artifact artifact) {
                ArtifactPointer pointer = ArtifactPointerManager.getInstance((Project)this.getProject()).createPointer(artifact);
                this.addSource((DeploymentSource)new LooseApplicationDeploymentSource(pointer));
            }

            public List<Artifact> getAvailableArtifacts() {
                Project project = this.getProject();
                if (project.isDefault()) {
                    return Collections.emptyList();
                }
                DeploymentManager deploymentManager = DeploymentManager.getInstance((Project)project);
                List supportedArtifacts = deploymentManager.getSupportedArtifacts((DeploymentProvider)new WebSphereDeploymentProvider());
                supportedArtifacts.removeAll(this.getAddedArtifacts());
                return supportedArtifacts;
            }

            private List<Artifact> getAddedArtifacts() {
                List artifactSources = ContainerUtil.findAll((Collection)this.getChosenSources(), com.intellij.javaee.deployment.ArtifactDeploymentSource.class);
                return ContainerUtil.map((Collection)artifactSources, ArtifactDeploymentSource::getArtifact);
            }
        };
    }

    public boolean isSourceProvided(DeploymentSource source) {
        return source instanceof LooseApplicationDeploymentSource;
    }
}

