/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.runDebug.configuration;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereFullHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereFullRemoteHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereLibertyHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereLibertyRemoteHandler;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereModel;
import com.intellij.j2ee.webSphere.runDebug.configuration.WebSphereRemoteRunConfigurationEditor;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;

public class WebSphereRemoteModel
extends WebSphereModel {
    private static final Logger LOG = Logger.getInstance((String)("#" + WebSphereRemoteModel.class.getName()));
    private Profile myProfile;

    public Profile getProfile() {
        return this.myProfile;
    }

    public void setProfile(Profile profile) {
        this.myProfile = profile;
    }

    public SettingsEditor<CommonModel> getEditor() {
        return new WebSphereRemoteRunConfigurationEditor(this.getCommonModel().getProject());
    }

    @Override
    protected WebSphereFullHandler createFullHandler(WebSphereVersion version) throws RuntimeConfigurationException {
        return new WebSphereFullRemoteHandler(this, version);
    }

    @Override
    protected WebSphereLibertyHandler createLibertyHandler() throws RuntimeConfigurationException {
        return new WebSphereLibertyRemoteHandler(this);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        Element dataElement = element.getChild("profile");
        if (dataElement != null) {
            this.myProfile = (Profile)XmlSerializer.deserialize((Element)dataElement, Profile.class);
        }
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        if (this.myProfile != null) {
            Element dataElement = XmlSerializer.serialize((Object)this.myProfile, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
            element.addContent(dataElement);
        }
    }

    public void parseProfile(String profile) {
        try {
            this.myProfile = (Profile)XmlSerializer.deserialize((Element)JDOMUtil.load((CharSequence)profile), Profile.class);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        catch (JDOMException e) {
            LOG.info((Throwable)e);
        }
    }

    @Tag(value="server")
    public static class Server {
        private String myName = "";

        @Attribute(value="name")
        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }
    }

    @Tag(value="node")
    public static class Node {
        private String myName = "";
        private List<Server> myServers = new ArrayList<Server>();

        @Attribute(value="name")
        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        @Tag(value="servers")
        @AbstractCollection(surroundWithTag=false)
        public List<Server> getServers() {
            return this.myServers;
        }

        public void setServers(List<Server> servers) {
            this.myServers = servers;
        }
    }

    @Tag(value="cell")
    public static class Cell {
        private String myName = "";
        private List<Node> myNodes = new ArrayList<Node>();

        @Attribute(value="name")
        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        @Tag(value="nodes")
        @AbstractCollection(surroundWithTag=false)
        public List<Node> getNodes() {
            return this.myNodes;
        }

        public void setNodes(List<Node> nodes) {
            this.myNodes = nodes;
        }
    }

    @Tag(value="profile")
    public static class Profile {
        private List<Cell> myCells = new ArrayList<Cell>();

        @Tag(value="cells")
        @AbstractCollection(surroundWithTag=false)
        public List<Cell> getCells() {
            return this.myCells;
        }

        public void setCells(List<Cell> cells) {
            this.myCells = cells;
        }
    }
}

