/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.connections;

import com.intellij.ProjectTopics;
import com.intellij.lifecycle.PeriodicalTasksCloser;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBusConnection;
import java.io.File;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.P4ConnectionCalculator;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionMapper;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.connections.PerforceMultipleConnections;
import org.jetbrains.idea.perforce.perforce.connections.PerforceP4ConfigVirtualFileListener;
import org.jetbrains.idea.perforce.perforce.connections.SingletonConnection;

public class PerforceConnectionManager
implements PerforceConnectionManagerI {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager");
    private PerforceSettings mySettings;
    private final Project myProject;
    private PerforceConnectionMapper myConnectionMapper;
    private final VirtualFileAdapter myVirtualFileListener;
    private MessageBusConnection myMessageBusConnection;
    private final Object myLock = new Object();
    private final PerforceConnectionProblemsNotifier myNotifier;

    public PerforceConnectionManager(Project project, PerforceConnectionProblemsNotifier notifier, PerforceSettings perforceSettings) {
        this.myNotifier = notifier;
        this.mySettings = perforceSettings;
        this.myProject = project;
        this.myVirtualFileListener = new PerforceP4ConfigVirtualFileListener(this, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerforceConnectionMapper getConnectionMapper() {
        PerforceConnectionMapper mapper;
        Object object = this.myLock;
        synchronized (object) {
            if (this.myConnectionMapper != null) {
                return this.myConnectionMapper;
            }
        }
        if (this.isSingletonConnectionUsed()) {
            mapper = SingletonConnection.getInstance(this.myProject);
        } else {
            P4ConnectionCalculator calculator = new P4ConnectionCalculator(this.myProject);
            calculator.execute();
            mapper = calculator.getMultipleConnections();
        }
        Object object2 = this.myLock;
        synchronized (object2) {
            if (this.myConnectionMapper == null) {
                this.myConnectionMapper = mapper;
                if (mapper instanceof PerforceMultipleConnections) {
                    this.myNotifier.setProblems(((PerforceMultipleConnections)mapper).hasAnyErrors(), false);
                }
            }
            return this.myConnectionMapper;
        }
    }

    @Override
    @Nullable
    public PerforceMultipleConnections getMultipleConnectionObject() {
        PerforceConnectionMapper mapper = this.getConnectionMapper();
        return mapper instanceof PerforceMultipleConnections ? (PerforceMultipleConnections)mapper : null;
    }

    public static PerforceConnectionManagerI getInstance(Project project) {
        return (PerforceConnectionManagerI)PeriodicalTasksCloser.getInstance().safeGetService(project, PerforceConnectionManagerI.class);
    }

    @Override
    @NotNull
    public Map<VirtualFile, P4Connection> getAllConnections() {
        Map<VirtualFile, P4Connection> map = this.getConnectionMapper().getAllConnections();
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager", "getAllConnections"));
        }
        return map;
    }

    private Project getProject() {
        return this.myProject;
    }

    @Nullable
    public static VirtualFile findNearestLiveParentFor(File ioFile) {
        do {
            VirtualFile parent;
            if ((parent = LocalFileSystem.getInstance().findFileByIoFile(ioFile)) == null) continue;
            return parent;
        } while ((ioFile = ioFile.getParentFile()) != null);
        return null;
    }

    @Override
    @Nullable
    public P4Connection getConnectionForFile(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager", "getConnectionForFile"));
        }
        if (this.isSingletonConnectionUsed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getConnectionForFile(" + file + ") returning singleton");
            }
            return (P4Connection)ReadAction.compute(() -> this.myProject.isDisposed() ? null : this.getConnectionMapper().getConnection(this.myProject.getBaseDir()));
        }
        VirtualFile vFile = PerforceConnectionManager.findNearestLiveParentFor(file);
        if (vFile == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("getConnectionForFile(" + file + ") found no live parent");
            }
            return null;
        }
        return this.getConnectionForFile(vFile);
    }

    @Override
    public P4Connection getConnectionForFile(@NotNull P4File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager", "getConnectionForFile"));
        }
        return this.getConnectionForFile(file.getLocalFile());
    }

    @Override
    public P4Connection getConnectionForFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager", "getConnectionForFile"));
        }
        return this.getConnectionMapper().getConnection(file);
    }

    @Override
    public boolean isSingletonConnectionUsed() {
        return !this.mySettings.useP4CONFIG;
    }

    public void startListening() {
        this.myMessageBusConnection = this.getProject().getMessageBus().connect();
        this.myMessageBusConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(ModuleRootEvent event) {
                PerforceConnectionManager.this.updateConnections();
            }
        });
        this.myMessageBusConnection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, this::updateConnections);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)this.myVirtualFileListener);
        this.updateConnections();
    }

    public void stopListening() {
        if (this.myMessageBusConnection != null) {
            this.myMessageBusConnection.disconnect();
            this.myMessageBusConnection = null;
        }
        VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)this.myVirtualFileListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConnections() {
        Object object = this.myLock;
        synchronized (object) {
            this.myConnectionMapper = null;
        }
        PerforceManager manager = PerforceManager.getInstance(this.getProject());
        manager.configurationChanged();
    }

    @Override
    public boolean isUnderProjectConnections(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager", "isUnderProjectConnections"));
        }
        Set<VirtualFile> allRoots = this.getConnectionMapper().getAllConnections().keySet();
        return ContainerUtil.or(allRoots, root -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/idea/perforce/perforce/connections/PerforceConnectionManager", "lambda$isUnderProjectConnections$1"));
            }
            return FileUtil.isAncestor((File)VfsUtilCore.virtualToIoFile((VirtualFile)root), (File)file, (boolean)false);
        });
    }
}

