/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.heroku.agent.cloud;

import com.heroku.api.App;
import com.heroku.api.HerokuAPI;
import com.heroku.api.Proc;
import com.heroku.api.exception.HerokuAPIException;
import com.heroku.api.request.log.Log;
import com.herokuapp.directto.client.DirectToHerokuClient;
import com.intellij.javaee.heroku.agent.HerokuApplicationImpl;
import com.intellij.javaee.heroku.agent.cloud.HerokuApiTaskProvider;
import com.intellij.javaee.heroku.agent.cloud.HerokuCloudAgentDeployment;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.CloudGitApplication;
import com.intellij.remoteServer.agent.util.log.LogAgentManager;
import com.intellij.remoteServer.agent.util.log.LogPipe;
import com.intellij.remoteServer.agent.util.log.LogPipeBase;
import com.intellij.remoteServer.agent.util.log.LogPipeProvider;
import com.intellij.remoteServer.agent.util.log.TerminalPipe;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class HerokuCloudAgentDeploymentImpl
implements HerokuCloudAgentDeployment {
    private static final String LOG_PIPE_NAME = "Log";
    private static final String PROCESS_TYPE = "web";
    private static final String JAVA_OPTS = "JAVA_OPTS";
    private static final String DEBUG_OPTION = "-Xdebug";
    private static final String RUN_JDWP_OPTION = "-Xrunjdwp:transport=dt_socket,address=";
    private final HerokuApiTaskProvider myTaskProvider;
    private final String myDeploymentName;
    private final CloudAgentLoggingHandler myDefaultLoggingHandler;
    private final LogAgentManager myLogManager;
    private final CloudAgentLogger myLogger;
    private final String myApiKey;
    private Integer myInitialDynoAmount;

    public HerokuCloudAgentDeploymentImpl(HerokuApiTaskProvider taskProvider, String deploymentName, CloudAgentLoggingHandler loggingHandler, LogAgentManager logManager, CloudAgentLogger logger, String apiKey) {
        this.myTaskProvider = taskProvider;
        this.myDeploymentName = deploymentName;
        this.myDefaultLoggingHandler = loggingHandler;
        this.myLogManager = logManager;
        this.myLogger = logger;
        this.myApiKey = apiKey;
    }

    public CloudGitApplication createApplication() {
        return (CloudGitApplication)new HerokuApiTaskProvider.ApiTask<CloudGitApplication>(this.myTaskProvider){

            @Override
            protected CloudGitApplication doPerform(HerokuAPI api) throws HerokuAPIException {
                return HerokuCloudAgentDeploymentImpl.this.doCreateApp(api);
            }
        }.perform();
    }

    private CloudGitApplication doCreateApp(HerokuAPI api) {
        return new HerokuApplicationImpl(api.createApp(new App().named(this.myDeploymentName)));
    }

    public CloudGitApplication findApplication() {
        return (CloudGitApplication)new HerokuApiTaskProvider.ApiTask<CloudGitApplication>(this.myTaskProvider){

            @Override
            protected CloudGitApplication doPerform(HerokuAPI api) throws HerokuAPIException {
                return HerokuCloudAgentDeploymentImpl.this.doFindApp(api);
            }
        }.perform();
    }

    private CloudGitApplication doFindApp(HerokuAPI api) {
        for (App app : api.listApps()) {
            if (!app.getName().equals(this.myDeploymentName)) continue;
            return new HerokuApplicationImpl(app);
        }
        return null;
    }

    public void deleteApplication() {
        new HerokuApiTaskProvider.ApiTask(this.myTaskProvider){

            protected Object doPerform(HerokuAPI api) throws HerokuAPIException {
                HerokuCloudAgentDeploymentImpl.this.destroyApp(api);
                return null;
            }
        }.perform();
    }

    public void startListeningLog(final CloudAgentLoggingHandler loggingHandler) {
        this.myLogManager.startListeningLog(this.myDeploymentName, new LogPipeProvider(){

            public List<? extends LogPipe> createLogPipes(String deploymentName) {
                return Collections.singletonList(new HerokuLogPipe(deploymentName, loggingHandler));
            }
        });
    }

    public void stopListeningLog() {
        this.myLogManager.stopListeningLog(this.myDeploymentName);
    }

    private void destroyApp(HerokuAPI api) {
        api.destroyApp(this.myDeploymentName);
    }

    public void deployWar(final File file) {
        HerokuApiTaskProvider herokuApiTaskProvider = this.myTaskProvider;
        herokuApiTaskProvider.getClass();
        new HerokuApiTaskProvider.ApiTask(herokuApiTaskProvider){

            protected Object doPerform(HerokuAPI api) throws HerokuAPIException {
                DirectToHerokuClient client = new DirectToHerokuClient.Builder().setApiKey(HerokuCloudAgentDeploymentImpl.this.myApiKey).build();
                if (HerokuCloudAgentDeploymentImpl.this.doFindApp(api) == null) {
                    HerokuCloudAgentDeploymentImpl.this.doCreateApp(api);
                }
                HashMap<String, File> files = new HashMap<String, File>(1);
                files.put("war", file);
                client.deploy("war", HerokuCloudAgentDeploymentImpl.this.myDeploymentName, files);
                return null;
            }
        }.perform();
    }

    public void attachDebugRemote(final String host, final Integer port) {
        HerokuApiTaskProvider herokuApiTaskProvider = this.myTaskProvider;
        herokuApiTaskProvider.getClass();
        new HerokuApiTaskProvider.ApiTask(herokuApiTaskProvider){

            protected Object doPerform(HerokuAPI api) throws HerokuAPIException {
                App app = api.getApp(HerokuCloudAgentDeploymentImpl.this.myDeploymentName);
                int appDynos = app.getDynos();
                if (appDynos > 1) {
                    HerokuCloudAgentDeploymentImpl.this.myInitialDynoAmount = appDynos;
                    api.scaleProcess(HerokuCloudAgentDeploymentImpl.this.myDeploymentName, HerokuCloudAgentDeploymentImpl.PROCESS_TYPE, 1);
                } else {
                    HerokuCloudAgentDeploymentImpl.this.myInitialDynoAmount = null;
                }
                Map appConfig = api.listConfig(HerokuCloudAgentDeploymentImpl.this.myDeploymentName);
                String javaOpts = (String)appConfig.get(HerokuCloudAgentDeploymentImpl.JAVA_OPTS);
                HashMap<String, String> javaOptsConfig = new HashMap<String, String>();
                javaOptsConfig.put(HerokuCloudAgentDeploymentImpl.JAVA_OPTS, javaOpts + " " + HerokuCloudAgentDeploymentImpl.DEBUG_OPTION + " " + HerokuCloudAgentDeploymentImpl.RUN_JDWP_OPTION + host + ":" + port);
                api.addConfig(HerokuCloudAgentDeploymentImpl.this.myDeploymentName, javaOptsConfig);
                return null;
            }
        }.perform();
    }

    public void detachDebugRemote() {
        new HerokuApiTaskProvider.ApiTask(this.myTaskProvider){

            protected Object doPerform(HerokuAPI api) throws HerokuAPIException {
                if (HerokuCloudAgentDeploymentImpl.this.doFindApp(api) == null) {
                    return null;
                }
                boolean needRestart = false;
                if (HerokuCloudAgentDeploymentImpl.this.myInitialDynoAmount != null) {
                    api.scaleProcess(HerokuCloudAgentDeploymentImpl.this.myDeploymentName, HerokuCloudAgentDeploymentImpl.PROCESS_TYPE, HerokuCloudAgentDeploymentImpl.this.myInitialDynoAmount.intValue());
                    needRestart = true;
                }
                Map appConfig = api.listConfig(HerokuCloudAgentDeploymentImpl.this.myDeploymentName);
                StringBuilder optsBuilder = new StringBuilder();
                String javaOpts = (String)appConfig.get(HerokuCloudAgentDeploymentImpl.JAVA_OPTS);
                if (javaOpts != null) {
                    String[] opts;
                    for (String opt : opts = javaOpts.split("\\s+")) {
                        if (opt.equals(HerokuCloudAgentDeploymentImpl.DEBUG_OPTION) || opt.startsWith(HerokuCloudAgentDeploymentImpl.RUN_JDWP_OPTION)) {
                            needRestart = true;
                            continue;
                        }
                        if (optsBuilder.length() > 0) {
                            optsBuilder.append(" ");
                        }
                        optsBuilder.append(opt);
                    }
                    HashMap<String, String> javaOptsConfig = new HashMap<String, String>();
                    javaOptsConfig.put(HerokuCloudAgentDeploymentImpl.JAVA_OPTS, optsBuilder.toString());
                    api.addConfig(HerokuCloudAgentDeploymentImpl.this.myDeploymentName, javaOptsConfig);
                }
                if (needRestart) {
                    api.restart(HerokuCloudAgentDeploymentImpl.this.myDeploymentName);
                }
                return null;
            }
        }.perform();
    }

    public void startBashSession() {
        new HerokuApiTaskProvider.ApiTask<Object>(this.myTaskProvider){

            @Override
            protected Object doPerform(HerokuAPI api) throws HerokuAPIException, IOException {
                final HerokuBashPipe bashPipe = new HerokuBashPipe(api);
                Proc proc = bashPipe.getProc();
                HerokuCloudAgentDeploymentImpl.this.myLogManager.startOrContinueListeningLog(proc.getProcess(), new LogPipeProvider(){

                    public List<? extends LogPipeBase> createLogPipes(String deploymentName) {
                        return Collections.singletonList(bashPipe);
                    }
                });
                return null;
            }
        }.perform();
    }

    public CloudGitApplication findApplication4Repository(final String[] repositoryUrls) {
        HerokuApiTaskProvider herokuApiTaskProvider = this.myTaskProvider;
        herokuApiTaskProvider.getClass();
        return (CloudGitApplication)new HerokuApiTaskProvider.ApiTask<CloudGitApplication>(herokuApiTaskProvider){

            @Override
            protected CloudGitApplication doPerform(HerokuAPI api) throws HerokuAPIException {
                HashSet<String> urlsSet = new HashSet<String>(Arrays.asList(repositoryUrls));
                for (App app : api.listApps()) {
                    if (!urlsSet.contains(app.getGitUrl())) continue;
                    return new HerokuApplicationImpl(app);
                }
                return null;
            }
        }.perform();
    }

    private class HerokuBashPipe
    extends TerminalPipe {
        private final Proc myProc;
        private final OutputStream myOutputStream;
        private final InputStream myInputStream;

        public HerokuBashPipe(HerokuAPI api) throws HerokuAPIException, IOException {
            super("Heroku Bash", HerokuCloudAgentDeploymentImpl.this.myDefaultLoggingHandler);
            this.myProc = api.runAttached(HerokuCloudAgentDeploymentImpl.this.myDeploymentName, "bash").getProc();
            String host = this.myProc.getRendezvousUrl().getHost();
            int port = this.myProc.getRendezvousUrl().getPort();
            String secret = this.myProc.getRendezvousUrl().getPath().substring(1);
            SocketFactory socketFactory = SSLSocketFactory.getDefault();
            Socket socket = socketFactory.createSocket(host, port);
            this.myInputStream = socket.getInputStream();
            this.myOutputStream = socket.getOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.myOutputStream);
            BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
            InputStreamReader inputStreamReader = new InputStreamReader(this.myInputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            bufferedWriter.write(secret);
            bufferedWriter.flush();
            bufferedReader.readLine();
            bufferedWriter.write("\n");
            bufferedWriter.flush();
        }

        public Proc getProc() {
            return this.myProc;
        }

        public OutputStream getOutputStream() {
            return this.myOutputStream;
        }

        public InputStream getInputStream() {
            return this.myInputStream;
        }

        public void close() {
            super.close();
            try {
                if (this.myOutputStream != null) {
                    this.myOutputStream.close();
                }
                if (this.myInputStream != null) {
                    this.myInputStream.close();
                }
            }
            catch (IOException e) {
                HerokuCloudAgentDeploymentImpl.this.myLogger.debugEx((Exception)e);
            }
        }
    }

    private class HerokuLogPipe
    extends LogPipe {
        public HerokuLogPipe(String deploymentName, CloudAgentLoggingHandler loggingHandler) {
            super(deploymentName, HerokuCloudAgentDeploymentImpl.LOG_PIPE_NAME, HerokuCloudAgentDeploymentImpl.this.myLogger, loggingHandler);
        }

        protected InputStream createInputStream(final String deploymentName) {
            HerokuApiTaskProvider herokuApiTaskProvider = HerokuCloudAgentDeploymentImpl.this.myTaskProvider;
            herokuApiTaskProvider.getClass();
            return (InputStream)new HerokuApiTaskProvider.ApiSilentTask<InputStream>(herokuApiTaskProvider){

                @Override
                protected InputStream doPerform(HerokuAPI api) throws HerokuAPIException {
                    return api.getLogs(new Log.LogRequestBuilder().app(deploymentName).tail(true)).openStream();
                }
            }.perform();
        }
    }
}

