/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui;

import com.android.tools.adtui.Animatable;
import com.android.tools.adtui.Choreographer;

public class Range
implements Animatable {
    private static final float DEFAULT_LERP_FRACTION = 0.95f;
    private static final float DEFAULT_LERP_THRESHOLD = 0.001f;
    private boolean mLock;
    private double mInitMax;
    private double mTargetMin;
    private double mTargetMax;
    private double mCurrentMin;
    private double mCurrentMax;
    private float mLerpFraction;
    private float mLerpThreshold;

    public Range(double min, double max) {
        this.mCurrentMin = this.mTargetMin = min;
        this.mCurrentMax = this.mTargetMax = max;
        this.mInitMax = this.mTargetMax;
        this.mLerpFraction = 0.95f;
        this.mLerpThreshold = 0.001f;
    }

    public Range() {
        this(0.0, 0.0);
    }

    @Override
    public void setLerpFraction(float fraction) {
        this.mLerpFraction = fraction;
    }

    @Override
    public void setLerpThreshold(float threshold) {
        this.mLerpThreshold = threshold;
    }

    public boolean setMin(double from) {
        if (this.mLock) {
            return false;
        }
        this.mTargetMin = this.mCurrentMin = from;
        return true;
    }

    public boolean setMinTarget(double fromTarget) {
        if (this.mLock) {
            return false;
        }
        this.mTargetMin = fromTarget;
        return true;
    }

    public boolean setMax(double to) {
        if (this.mLock) {
            return false;
        }
        this.mTargetMax = this.mCurrentMax = to;
        return true;
    }

    public boolean setMaxTarget(double to) {
        if (this.mLock) {
            return false;
        }
        this.mTargetMax = to;
        return true;
    }

    public boolean set(double min, double max) {
        if (this.mLock) {
            return false;
        }
        this.setMin(min);
        this.setMax(max);
        return true;
    }

    public boolean setTarget(double targetMin, double targetMax) {
        if (this.mLock) {
            return false;
        }
        this.setMinTarget(targetMin);
        this.setMaxTarget(targetMax);
        return true;
    }

    @Override
    public void animate(float frameLength) {
        if (this.mCurrentMin != this.mTargetMin) {
            this.mCurrentMin = Choreographer.lerp(this.mCurrentMin, this.mTargetMin, this.mLerpFraction, frameLength, this.mLerpThreshold);
        }
        if (this.mCurrentMax != this.mTargetMax) {
            this.mCurrentMax = Choreographer.lerp(this.mCurrentMax, this.mTargetMax, this.mLerpFraction, frameLength, this.mLerpThreshold);
        }
    }

    @Override
    public void postAnimate() {
        this.mLock = false;
    }

    public void lockValues() {
        this.mLock = true;
    }

    public double getTargetLength() {
        return this.mTargetMax - this.mTargetMin;
    }

    public double getInitialMax() {
        return this.mInitMax;
    }

    public double getMaxTarget() {
        return this.mTargetMax;
    }

    public double getMin() {
        return this.mCurrentMin;
    }

    public double getMax() {
        return this.mCurrentMax;
    }

    public double getLength() {
        return Math.abs(this.mCurrentMax - this.mCurrentMin);
    }

    public boolean isPoint() {
        return this.getMax() == this.getMin();
    }

    public double clamp(double value) {
        return Math.min(Math.max(this.getMin(), value), this.getMax());
    }

    public boolean flip() {
        return this.set(this.getMax(), this.getMin());
    }

    public boolean shift(double delta) {
        return this.set(this.getMin() + delta, this.getMax() + delta);
    }
}

