/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.Range;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.SeriesData;
import com.intellij.util.containers.ImmutableList;
import gnu.trove.TLongArrayList;
import org.jetbrains.annotations.NotNull;

public abstract class BaseDataSeries<E>
implements DataSeries<E> {
    @NotNull
    protected final TLongArrayList mX = new TLongArrayList();

    @NotNull
    private ImmutableList<SeriesData<E>> getDataSubList(final int fromIndex, final int toIndex) {
        ImmutableList immutableList = new ImmutableList<SeriesData<E>>(){

            public int size() {
                return toIndex - fromIndex;
            }

            public SeriesData<E> get(int index) {
                assert (index < this.size());
                SeriesData data = new SeriesData();
                data.x = BaseDataSeries.this.getX(index + fromIndex);
                data.value = BaseDataSeries.this.getY(index + fromIndex);
                return data;
            }
        };
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/model/BaseDataSeries", "getDataSubList"));
        }
        return immutableList;
    }

    @Override
    public ImmutableList<SeriesData<E>> getDataForXRange(Range xRange) {
        if (this.size() == 0) {
            return this.getDataSubList(0, 0);
        }
        int fromIndex = this.getNearestXIndex((long)xRange.getMin());
        int toIndex = this.getNearestXIndex((long)xRange.getMax()) + 1;
        return this.getDataSubList(fromIndex, toIndex);
    }

    public ImmutableList<SeriesData<E>> getAllData() {
        return this.getDataSubList(0, this.size());
    }

    @Override
    public SeriesData<E> getDataAtXValue(long x) {
        int index = this.getNearestXIndex(x);
        SeriesData data = new SeriesData();
        data.x = this.getX(index);
        data.value = this.getY(index);
        return data;
    }

    public abstract void add(long var1, E var3);

    public int size() {
        return this.mX.size();
    }

    public long getX(int index) {
        return this.mX.get(index);
    }

    public abstract E getY(int var1);

    public int getNearestXIndex(long x) {
        int index = this.mX.binarySearch(x);
        if (index < 0) {
            index = -index - 2;
        }
        return Math.max(0, Math.min(index, this.size() - 1));
    }
}

