/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.model;

import com.android.tools.adtui.Range;
import com.android.tools.adtui.common.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.ReportingSeries;
import com.android.tools.adtui.model.SeriesData;
import com.intellij.util.containers.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RangedContinuousSeries
extends RangedSeries<Long>
implements ReportingSeries {
    @NotNull
    private final String mLabel;
    @NotNull
    private final Range mYRange;
    private BaseAxisFormatter mXAxisFormatter;
    private BaseAxisFormatter mYAxisFormatter;

    public RangedContinuousSeries(@NotNull String label, @NotNull Range xRange, @NotNull Range yRange, @NotNull DataSeries series) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/adtui/model/RangedContinuousSeries", "<init>"));
        }
        if (xRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xRange", "com/android/tools/adtui/model/RangedContinuousSeries", "<init>"));
        }
        if (yRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yRange", "com/android/tools/adtui/model/RangedContinuousSeries", "<init>"));
        }
        if (series == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "series", "com/android/tools/adtui/model/RangedContinuousSeries", "<init>"));
        }
        super(xRange, series);
        this.mYRange = yRange;
        this.mLabel = label;
    }

    public RangedContinuousSeries(@NotNull String label, @NotNull Range xRange, @NotNull Range yRange, @NotNull DataSeries series, @NotNull BaseAxisFormatter xAxisFormatter, @NotNull BaseAxisFormatter yAxisFormatter) {
        if (label == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "label", "com/android/tools/adtui/model/RangedContinuousSeries", "<init>"));
        }
        if (xRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xRange", "com/android/tools/adtui/model/RangedContinuousSeries", "<init>"));
        }
        if (yRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yRange", "com/android/tools/adtui/model/RangedContinuousSeries", "<init>"));
        }
        if (series == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "series", "com/android/tools/adtui/model/RangedContinuousSeries", "<init>"));
        }
        if (xAxisFormatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xAxisFormatter", "com/android/tools/adtui/model/RangedContinuousSeries", "<init>"));
        }
        if (yAxisFormatter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yAxisFormatter", "com/android/tools/adtui/model/RangedContinuousSeries", "<init>"));
        }
        this(label, xRange, yRange, series);
        this.mXAxisFormatter = xAxisFormatter;
        this.mYAxisFormatter = yAxisFormatter;
    }

    @NotNull
    public Range getYRange() {
        Range range = this.mYRange;
        if (range == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/model/RangedContinuousSeries", "getYRange"));
        }
        return range;
    }

    @Override
    @NotNull
    public String getLabel() {
        String string = this.mLabel;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/adtui/model/RangedContinuousSeries", "getLabel"));
        }
        return string;
    }

    private static SeriesData<Long> getMaxYValue(ImmutableList<SeriesData<Long>> series) {
        SeriesData maxData = (SeriesData)series.get(0);
        for (int i = 1; i < series.size(); ++i) {
            SeriesData data = (SeriesData)series.get(i);
            if (maxData.x < data.x) {
                maxData.x = data.x;
            }
            if ((Long)maxData.value >= (Long)data.value) continue;
            maxData.value = data.value;
        }
        return maxData;
    }

    @Nullable
    private ReportingSeries.ReportingData getReportingData(long time) {
        ImmutableList series = this.getSeries();
        if (series.size() == 0) {
            return null;
        }
        SeriesData data = this.mSeries.getDataAtXValue(time);
        SeriesData<Long> maxData = RangedContinuousSeries.getMaxYValue(series);
        long nearestX = data.x;
        long nearestY = (Long)data.value;
        long maxX = maxData.x;
        long maxY = (Long)maxData.value;
        String formattedY = this.mYAxisFormatter == null ? Long.toString(nearestY) : this.mYAxisFormatter.getFormattedString(maxY, nearestY);
        String formattedX = this.mXAxisFormatter == null ? Long.toString(nearestX) : this.mXAxisFormatter.getFormattedString(maxX, nearestX);
        return new ReportingSeries.ReportingData(nearestX, formattedX, formattedY);
    }

    @Override
    @Nullable
    public ReportingSeries.ReportingData getLatestReportingData() {
        return this.getReportingData((long)this.mXRange.getMax());
    }

    @Override
    public Collection<ReportingSeries.ReportingData> getFullReportingData(long x) {
        ArrayList<ReportingSeries.ReportingData> dataList = new ArrayList<ReportingSeries.ReportingData>();
        ReportingSeries.ReportingData report = this.getReportingData(x);
        if (report != null) {
            dataList.add(report);
        }
        return dataList;
    }
}

