/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.composite;

import com.intellij.jsf.composite.CompositeComponentQuickFixProvider;
import com.intellij.jsf.facelets.FaceletsManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.jsp.BaseJspFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.refactoring.lang.jsp.extractInclude.ExtractJspIncludeFileHandler;
import com.intellij.refactoring.lang.jsp.extractTag.ExtractJspxTagHandler;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Set;

public class ExtractFaceletsComponentHandler
extends ExtractJspxTagHandler {
    public String getActionName() {
        return "Extract Composite Component";
    }

    protected boolean acceptFile(BaseJspFile file) {
        return FaceletsManager.isFaceletFile((PsiFile)file);
    }

    public String getTagExtension() {
        return "xhtml";
    }

    public String getTagFileLocation() {
        return "/resources";
    }

    protected String getNamespace(String tagdir) {
        return "http://java.sun.com/jsf/composite" + tagdir.substring(this.getTagFileLocation().length());
    }

    public String getTagFileText(Editor editor, PsiFile file) {
        Pair pair = ExtractFaceletsComponentHandler.getSelectedPair((Editor)editor, (PsiFile)file);
        if (pair == null) {
            return null;
        }
        XmlTag parentTag = ExtractJspIncludeFileHandler.getParentTag((XmlTagChild)((XmlTagChild)pair.first));
        Set namespaces = ExtractJspIncludeFileHandler.getUsedNamespaces((XmlTagChild)((XmlTagChild)pair.first), (XmlTagChild)((XmlTagChild)pair.second));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("IMPLEMENTATION", editor.getSelectionModel().getSelectedText());
        Project project = file.getProject();
        String text = CompositeComponentQuickFixProvider.getCompositeText(map, project);
        if (text == null) {
            return null;
        }
        XmlFile psiFile = (XmlFile)PsiFileFactory.getInstance((Project)project).createFileFromText("a.xhtml", text);
        XmlTag rootTag = psiFile.getRootTag();
        assert (rootTag != null);
        for (String namespace : namespaces) {
            if (rootTag.getNSDescriptor(namespace, true) != null) continue;
            String prefix = parentTag.getPrefixByNamespace(namespace);
            String attrName = prefix == null ? "xmlns" : "xmlns:" + prefix;
            rootTag.setAttribute(attrName, namespace);
        }
        CodeStyleManager.getInstance((Project)project).reformat((PsiElement)psiFile);
        return psiFile.getText();
    }

    public String validateLocation(String locationPath) {
        String text = super.validateLocation(locationPath);
        if (text != null) {
            return null;
        }
        int pos = (locationPath + "/").indexOf(this.getTagFileLocation() + "/");
        String tagdir = locationPath.substring(pos + this.getTagFileLocation().length());
        String s = StringUtil.strip((String)tagdir, (CharFilter)new CharFilter(){

            public boolean accept(char ch) {
                return ch != '/';
            }
        });
        return StringUtil.isEmpty((String)s) ? "" : null;
    }

    public String guessLocation(VirtualFile dir) {
        Object[] children;
        String location = super.guessLocation(dir);
        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(location);
        if (file != null && file.isDirectory() && (children = file.getChildren()) != null) {
            VirtualFile firstDir = (VirtualFile)ContainerUtil.find((Object[])children, virtualFile -> virtualFile.isDirectory());
            return firstDir == null ? location : firstDir.getPath();
        }
        return location;
    }
}

