/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.toolWindow.tree.nodes;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jsf.model.jam.JsfJamConverter;
import com.intellij.jsf.model.jam.JsfJamModel;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.converter.JsfDomConverter;
import com.intellij.jsf.resources.FacesUIBundle;
import com.intellij.jsf.toolWindow.tree.nodes.AbstractJsfTypeNode;
import com.intellij.jsf.toolWindow.tree.nodes.AnnotatedMembersNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfDomModelElementNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModelElementNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModuleNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfNodeTypes;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.ui.treeStructure.SimpleNode;
import icons.JsfIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ConvertersNode
extends AbstractJsfTypeNode {
    public ConvertersNode(Module module, JsfModuleNode jsfModuleNode, boolean showFromLibraries) {
        super(jsfModuleNode, module, JsfNodeTypes.CONVERTER, showFromLibraries);
        this.setUniformIcon(JsfIcons.Converter);
    }

    protected void doUpdate() {
        this.setPlainText(FacesUIBundle.message("converters.node.name", new Object[0]));
    }

    @Override
    protected void addAnnotatedNodes(Collection<JsfModelElementNode> nodes) {
        List<JsfJamConverter> jamElements = JsfJamModel.getModel(this.getModule()).getConverters(this.isShowFromLibraries());
        for (JsfJamConverter converter : jamElements) {
            nodes.add(new AnnotatedMembersNode<PsiClass>(this.getModule(), converter.getPsiElement(), this));
        }
    }

    @Override
    @NotNull
    protected Collection<SimpleNode> getFacesDomModelNodes(@NotNull FacesDomModel domModel) {
        if (domModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domModel", "com/intellij/jsf/toolWindow/tree/nodes/ConvertersNode", "getFacesDomModelNodes"));
        }
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        List<JsfDomConverter> converters = domModel.getFacesConfig().getConverters();
        for (final JsfDomConverter converter : converters) {
            nodes.add(new JsfDomModelElementNode<JsfDomConverter>(this.getProject(), (NodeDescriptor)this, converter, JsfIcons.Converter){

                @Override
                protected String getActualNodeName() {
                    return converter.getConverterClass().getStringValue();
                }

                @Override
                protected String getNodeTextExt() {
                    return converter.getConverterForClass().getStringValue();
                }
            });
        }
        ArrayList<SimpleNode> arrayList = nodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/toolWindow/tree/nodes/ConvertersNode", "getFacesDomModelNodes"));
        }
        return arrayList;
    }
}

