/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.yfilesGraph;

import com.intellij.jsf.model.xml.FacesConfig;
import com.intellij.jsf.model.xml.navigationRules.NavigationCase;
import com.intellij.jsf.utils.JsfCommonUtils;
import com.intellij.jsf.yfilesGraph.renderer.BasicFacesNodeCellRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.EdgeCursor;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.EdgeCreationPolicy;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.components.SelectionDependenciesPresentationModel;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.NodeCellRenderer;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFacesGraphPresentationModel
extends SelectionDependenciesPresentationModel<String, NavigationCase> {
    private final FacesConfig myFacesConfig;
    @NonNls
    private static final String BASIC_GRAPH_CONFIGURATION = "BASIC_GRAPH_CONFIGURATION";
    private BasicFacesNodeCellRenderer myCellRenderer;

    public AbstractFacesGraphPresentationModel(FacesConfig facesConfig, Graph2D graph) {
        super((Graph)graph);
        this.myFacesConfig = facesConfig;
    }

    public BasicFacesNodeCellRenderer getCellRenderer() {
        if (this.myCellRenderer == null) {
            this.myCellRenderer = new BasicFacesNodeCellRenderer(this.getFacesConfig(), (GraphBuilder<String, NavigationCase>)this.getGraphBuilder());
            Disposer.register((Disposable)this, (Disposable)this.myCellRenderer);
        }
        return this.myCellRenderer;
    }

    public String getNodeTooltip(String s) {
        return this.getNodeTip(this.getGraphBuilder().getNode((Object)s));
    }

    public String getEdgeTooltip(NavigationCase navigationCase) {
        return this.getEdgeTip(navigationCase);
    }

    public boolean editNode(String s) {
        return this.startNodeEditing(s);
    }

    public boolean editEdge(NavigationCase navigationCase) {
        VirtualFile file;
        XmlTag tag = navigationCase.getXmlTag();
        if (tag != null && tag.getContainingFile() != null && (file = tag.getContainingFile().getVirtualFile()) != null) {
            int offset = tag.getTextOffset();
            FileEditorManagerImpl editorManager = (FileEditorManagerImpl)FileEditorManager.getInstance((Project)tag.getProject());
            editorManager.openTextEditor(new OpenFileDescriptor(tag.getProject(), file, offset), true);
            return true;
        }
        return false;
    }

    private boolean startNodeEditing(String node) {
        if (!this.doNodeEditing(node)) {
            return false;
        }
        if (node != null) {
            JsfCommonUtils.navigate(this.myFacesConfig, node);
        }
        return true;
    }

    protected boolean doNodeEditing(String node) {
        return true;
    }

    @Nullable
    @NonNls
    protected String getEdgeTip(NavigationCase nc) {
        if (nc == null) {
            return null;
        }
        Edge edge = this.getGraphBuilder().getEdge((Object)nc);
        return edge != null ? "<html><table><tr><td>from:</td><td>\"" + this.getNodeName(edge.source()) + "\"" + this.getNodeName(edge.target()) + "\"</td></tr></table></html>" : "";
    }

    @NotNull
    @NonNls
    protected String getNodeTip(Node node) {
        String tip = "<html><b>\"" + this.getNodeName(node) + "\"</b><table>";
        EdgeCursor toCursor = node.inEdges();
        tip = tip + "<tr><td valign=\"top\"> from (" + toCursor.size() + "): </td><td><table>";
        while (toCursor.ok()) {
            tip = tip + "<tr><td> -&nbsp;" + this.getNodeName(toCursor.edge().opposite(node)) + "</td></tr>";
            toCursor.next();
        }
        tip = tip + "";
        EdgeCursor outCursor = node.outEdges();
        tip = tip + "<tr><td valign=\"top\"> to (" + outCursor.size() + "): </td><td><table>";
        while (outCursor.ok()) {
            tip = tip + "<tr><td> -&nbsp;" + this.getNodeName(outCursor.edge().opposite(node)) + "</td></tr>";
            outCursor.next();
        }
        tip = tip + "";
        String string = tip = tip + "</table>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/yfilesGraph/AbstractFacesGraphPresentationModel", "getNodeTip"));
        }
        return string;
    }

    public DefaultActionGroup getNodeActionGroup(String o) {
        return this.getNodeActions();
    }

    public DefaultActionGroup getEdgeActionGroup(NavigationCase n) {
        return this.getPaperPopupActions();
    }

    public DefaultActionGroup getPaperActionGroup() {
        return this.getPaperPopupActions();
    }

    private DefaultActionGroup getPaperPopupActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("Graph.Faces.DefaultGraphPopup"));
        return group;
    }

    private DefaultActionGroup getNodeActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("Graph.Faces.DefaultGraphPopup"));
        return group;
    }

    private String getNodeName(Node node) {
        GraphBuilder builder = this.getGraphBuilder();
        if (builder == null) {
            return "";
        }
        String nodeName = builder.getNodeName(builder.getNodeObject(node));
        if ("EMPTY_NODE".equals(nodeName)) {
            nodeName = "*";
        }
        return nodeName;
    }

    public FacesConfig getFacesConfig() {
        return this.myFacesConfig;
    }

    protected NodeRealizer getDefaultFacesRealizer() {
        return GraphViewUtil.createNodeRealizer((String)BASIC_GRAPH_CONFIGURATION, (NodeCellRenderer)this.getCellRenderer());
    }

    public void customizeSettings(Graph2DView view, EditMode editMode) {
    }

    public EdgeCreationPolicy<String> getEdgeCreationPolicy() {
        return new EdgeCreationPolicy<String>(){

            public boolean acceptSource(@NotNull String source) {
                if (source == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/jsf/yfilesGraph/AbstractFacesGraphPresentationModel$1", "acceptSource"));
                }
                return true;
            }

            public boolean acceptTarget(@NotNull String target) {
                if (target == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/jsf/yfilesGraph/AbstractFacesGraphPresentationModel$1", "acceptTarget"));
                }
                return !"EMPTY_NODE".equals(target);
            }
        };
    }

    public void dispose() {
        super.dispose();
    }
}

