/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.inspections.model;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;

public class FileTypeComboboxItem {
    private final BDDFrameworkType myFrameworkType;
    private final String myDefaultFileName;

    public FileTypeComboboxItem(@NotNull BDDFrameworkType frameworkType, @NotNull String defaultFileName) {
        if (frameworkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameworkType", "org/jetbrains/plugins/cucumber/inspections/model/FileTypeComboboxItem", "<init>"));
        }
        if (defaultFileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultFileName", "org/jetbrains/plugins/cucumber/inspections/model/FileTypeComboboxItem", "<init>"));
        }
        this.myFrameworkType = frameworkType;
        this.myDefaultFileName = defaultFileName;
    }

    public String toString() {
        String fileType = StringUtil.capitalizeWords((String)this.myFrameworkType.getFileType().getName().toLowerCase(), (boolean)true);
        String additionalInfo = this.myFrameworkType.getAdditionalInfo();
        return additionalInfo != null ? String.format("%s (%s)", fileType, additionalInfo) : fileType;
    }

    public BDDFrameworkType getFrameworkType() {
        return this.myFrameworkType;
    }

    public String getDefaultFileName() {
        return this.myDefaultFileName;
    }
}

