/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.psi.GherkinStep;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinFileImpl;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;

public class GherkinPsiUtil {
    private GherkinPsiUtil() {
    }

    @Nullable
    public static GherkinFileImpl getGherkinFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/psi/GherkinPsiUtil", "getGherkinFile"));
        }
        if (!element.isValid()) {
            return null;
        }
        PsiFile containingFile = element.getContainingFile();
        return containingFile instanceof GherkinFileImpl ? (GherkinFileImpl)containingFile : null;
    }

    @Nullable
    public static List<TextRange> buildParameterRanges(@NotNull GherkinStep step, @NotNull AbstractStepDefinition definition, int shiftOffset) {
        if (step == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "step", "org/jetbrains/plugins/cucumber/psi/GherkinPsiUtil", "buildParameterRanges"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "org/jetbrains/plugins/cucumber/psi/GherkinPsiUtil", "buildParameterRanges"));
        }
        ArrayList<TextRange> parameterRanges = new ArrayList<TextRange>();
        Pattern pattern = definition.getPattern();
        if (pattern == null) {
            return null;
        }
        Perl5Matcher matcher = new Perl5Matcher();
        if (matcher.contains(step.getStepName(), pattern)) {
            MatchResult match = matcher.getMatch();
            int groupCount = match.groups();
            for (int i = 1; i < groupCount; ++i) {
                int start = match.beginOffset(i);
                int end = match.endOffset(i);
                if (start < 0 || end < 0) continue;
                parameterRanges.add(new TextRange(start, end).shiftRight(shiftOffset));
            }
        }
        int k = step.getText().indexOf(step.getStepName());
        if ((k += step.getStepName().length()) < step.getText().length() - 1) {
            String text = step.getText().substring(k + 1);
            boolean inParam = false;
            int paramStart = 0;
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) == '<') {
                    paramStart = i;
                    inParam = true;
                }
                if (text.charAt(i) != '>' || !inParam) continue;
                parameterRanges.add(new TextRange(paramStart, i + 1).shiftRight(shiftOffset + step.getStepName().length() + 1));
                inParam = false;
            }
        }
        return parameterRanges;
    }
}

