/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps.reference;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.CucumberJvmExtensionPoint;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinStepImpl;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.CucumberStepsIndex;

public class CucumberStepReference
implements PsiPolyVariantReference {
    private final PsiElement myStep;
    private final TextRange myRange;

    public CucumberStepReference(PsiElement step, TextRange range) {
        this.myStep = step;
        this.myRange = range;
    }

    public PsiElement getElement() {
        return this.myStep;
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    public PsiElement resolve() {
        ResolveResult[] result = this.multiResolve(true);
        return result.length == 1 ? result[0].getElement() : null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myStep.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.myStep;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReference", "bindToElement"));
        }
        return this.myStep;
    }

    public boolean isReferenceTo(PsiElement element) {
        ResolveResult[] resolvedResults;
        for (ResolveResult rr : resolvedResults = this.multiResolve(false)) {
            if (!this.getElement().getManager().areElementsEquivalent(rr.getElement(), element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        CucumberJvmExtensionPoint[] extensionList;
        ArrayList<1> result = new ArrayList<1>();
        ArrayList<PsiElement> resolvedElements = new ArrayList<PsiElement>();
        for (CucumberJvmExtensionPoint e : extensionList = (CucumberJvmExtensionPoint[])Extensions.getExtensions(CucumberJvmExtensionPoint.EP_NAME)) {
            List<PsiElement> extensionResult = e.resolveStep(this.myStep);
            for (final PsiElement element : extensionResult) {
                if (element == null || resolvedElements.contains(element)) continue;
                resolvedElements.add(element);
                result.add(new ResolveResult(){

                    public PsiElement getElement() {
                        return element;
                    }

                    public boolean isValidResult() {
                        return true;
                    }
                });
            }
        }
        ResolveResult[] resolveResultArray = result.toArray(new ResolveResult[result.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    @Nullable
    public AbstractStepDefinition resolveToDefinition() {
        Collection<AbstractStepDefinition> definitions = this.resolveToDefinitions();
        return definitions.isEmpty() ? null : definitions.iterator().next();
    }

    @NotNull
    public Collection<AbstractStepDefinition> resolveToDefinitions() {
        CucumberStepsIndex index = CucumberStepsIndex.getInstance(this.myStep.getProject());
        Collection<AbstractStepDefinition> collection = index.findStepDefinitions(this.myStep.getContainingFile(), (GherkinStepImpl)this.myStep);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReference", "resolveToDefinitions"));
        }
        return collection;
    }
}

