/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.websocket.model.messaging;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.TextRange;
import com.intellij.spring.model.utils.AntPathMatcher;
import com.intellij.spring.model.utils.PlaceholderTextRanges;
import com.intellij.spring.websocket.model.messaging.SpringMessagingType;
import com.intellij.spring.websocket.model.messaging.UrlCollector;
import com.intellij.spring.websocket.model.messaging.UrlPointer;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringMessagingModel {
    @NotNull
    private final NotNullLazyValue<MultiMap<SpringMessagingType, Variant>> myUrls;

    public SpringMessagingModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/websocket/model/messaging/SpringMessagingModel", "<init>"));
        }
        this.myUrls = new UrlCollector(module);
    }

    @NotNull
    public Collection<? extends Variant> getAllUrls() {
        Collection collection = ((MultiMap)this.myUrls.getValue()).values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/model/messaging/SpringMessagingModel", "getAllUrls"));
        }
        return collection;
    }

    @NotNull
    public Collection<Variant> getUrls(SpringMessagingType ... types) {
        if (types == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "com/intellij/spring/websocket/model/messaging/SpringMessagingModel", "getUrls"));
        }
        ArrayList<Variant> result = new ArrayList<Variant>();
        for (SpringMessagingType type : types) {
            result.addAll(((MultiMap)this.myUrls.getValue()).get((Object)type));
        }
        ArrayList<Variant> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/websocket/model/messaging/SpringMessagingModel", "getUrls"));
        }
        return arrayList;
    }

    private static String substitutePathVariables(String url) {
        Set ranges = PlaceholderTextRanges.getPlaceholderRanges((String)url, (String)"{", (String)"}");
        if (!ranges.isEmpty()) {
            if (ranges.size() > 1) {
                Iterator iterator = ranges.iterator();
                TextRange range = (TextRange)iterator.next();
                do {
                    TextRange next;
                    if ((next = (TextRange)iterator.next()).intersects(range)) {
                        return url;
                    }
                    range = next;
                } while (iterator.hasNext());
            }
            StringBuilder builder = new StringBuilder(url.length());
            int offset = 0;
            for (TextRange range : ranges) {
                builder.append(url.substring(offset, range.getStartOffset() - 1));
                builder.append('*');
                offset = range.getEndOffset() + 1;
            }
            builder.append(url.substring(offset));
            url = builder.toString();
        }
        return url;
    }

    public static class Variant {
        @NotNull
        public final UrlPointer appPrefix;
        @Nullable
        public final UrlPointer classPrefix;
        @NotNull
        public final UrlPointer urlDefinition;
        public final String presentation;
        public final String lookupString;
        public final boolean isPattern;
        public final UrlPointer[] parts;

        public Variant(@NotNull UrlPointer appPrefix, @Nullable UrlPointer classPrefix, @NotNull UrlPointer urlDefinition) {
            if (appPrefix == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "appPrefix", "com/intellij/spring/websocket/model/messaging/SpringMessagingModel$Variant", "<init>"));
            }
            if (urlDefinition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "urlDefinition", "com/intellij/spring/websocket/model/messaging/SpringMessagingModel$Variant", "<init>"));
            }
            this.appPrefix = appPrefix;
            this.classPrefix = classPrefix;
            this.urlDefinition = urlDefinition;
            this.presentation = this.buildPresentation();
            this.lookupString = SpringMessagingModel.substitutePathVariables(this.presentation);
            this.isPattern = AntPathMatcher.isPattern((String)this.lookupString);
            this.parts = new UrlPointer[]{appPrefix, classPrefix, urlDefinition};
        }

        private String buildPresentation() {
            StringBuilder builder = new StringBuilder(this.appPrefix.getUrl()).append("/");
            if (this.classPrefix != null) {
                builder.append(this.classPrefix.getUrl());
            }
            builder.append(Variant.\u0441onnectingSlashNeeded(builder)).append(this.urlDefinition.getUrl());
            return builder.toString();
        }

        private static String \u0441onnectingSlashNeeded(StringBuilder builder) {
            return !builder.toString().endsWith("/") ? "/" : "";
        }

        public String toString() {
            return String.format("%s (%s)", this.presentation, this.lookupString);
        }
    }
}

