/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesView;
import com.intellij.dupLocator.resultUI.InvalidatedException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.diff.SimpleDiffRequest;
import com.intellij.openapi.diff.ex.DiffPanelEx;
import com.intellij.openapi.diff.ex.DiffPanelOptions;
import com.intellij.openapi.diff.impl.ComparisonPolicy;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.highlighter.FragmentedEditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterClient;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.editor.highlighter.LightHighlighterClient;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseDuplicatesView
extends DuplicatesView {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.dupLocator.resultUI.BaseDuplicatesView");
    private final Project myProject;
    private final DiffPanelEx myDiffPanel;

    public BaseDuplicatesView(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dupLocator/resultUI/BaseDuplicatesView", "<init>"));
        }
        this.myProject = project;
        this.myDiffPanel = (DiffPanelEx)DiffManager.getInstance().createDiffPanel(null, project, (Disposable)this, null);
        this.myDiffPanel.setComparisonPolicy(ComparisonPolicy.IGNORE_SPACE);
        DiffPanelOptions diffPanelOptions = this.myDiffPanel.getOptions();
        diffPanelOptions.setShowSourcePolicy(DiffPanelOptions.ShowSourcePolicy.OPEN_EDITOR);
        diffPanelOptions.setRequestFocusOnNewContent(false);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myDiffPanel.getComponent();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dupLocator/resultUI/BaseDuplicatesView", "getComponent"));
        }
        return jComponent;
    }

    @Override
    public void setContent(@NotNull CodeNode left, @NotNull CodeNode right) {
        FragmentedEditorHighlighter rightHighlighter;
        if (left == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "left", "com/intellij/dupLocator/resultUI/BaseDuplicatesView", "setContent"));
        }
        if (right == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "right", "com/intellij/dupLocator/resultUI/BaseDuplicatesView", "setContent"));
        }
        SimpleDiffRequest request = new SimpleDiffRequest(this.myProject, null);
        request.setToolbarAddons(DiffRequest.ToolbarAddons.IDE_FRAME);
        DiffContent leftContent = left.getDiffContentIfValid();
        DiffContent rightContent = right.getDiffContentIfValid();
        if (leftContent == null || rightContent == null) {
            return;
        }
        request.setContents(leftContent, rightContent);
        request.setContentTitles(left.getTitle(false).getText(), right.getTitle(false).getText());
        this.myDiffPanel.setDiffRequest((DiffRequest)request);
        FragmentedEditorHighlighter leftHighlighter = this.createHighlighter(left);
        if (leftHighlighter != null) {
            ((EditorEx)this.myDiffPanel.getEditor1()).setHighlighter((EditorHighlighter)leftHighlighter);
        }
        if ((rightHighlighter = this.createHighlighter(right)) != null) {
            ((EditorEx)this.myDiffPanel.getEditor2()).setHighlighter((EditorHighlighter)rightHighlighter);
        }
    }

    @Nullable
    private FragmentedEditorHighlighter createHighlighter(CodeNode node) {
        TextRange range;
        PsiFile file = node.getFragment().getFile();
        if (file == null) {
            return null;
        }
        FileType fileType = file.getFileType();
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        if (document == null) {
            return null;
        }
        try {
            range = node.getTextRange();
        }
        catch (InvalidatedException e) {
            LOG.info((Throwable)e);
            return null;
        }
        EditorHighlighterFactory editorHighlighterFactory = EditorHighlighterFactory.getInstance();
        SyntaxHighlighter syntaxHighlighter = SyntaxHighlighterFactory.getSyntaxHighlighter((FileType)fileType, (Project)this.myProject, null);
        EditorHighlighter highlighter = editorHighlighterFactory.createEditorHighlighter(syntaxHighlighter, EditorColorsManager.getInstance().getGlobalScheme());
        highlighter.setEditor((HighlighterClient)new LightHighlighterClient(document, this.myProject));
        highlighter.setText((CharSequence)document.getText());
        HighlighterIterator iterator = highlighter.createIterator(range.getStartOffset());
        return new FragmentedEditorHighlighter(iterator, Collections.singletonList(range));
    }
}

