/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.javaee.openshift.agent.cloud.os3.OS3AgentDeployment;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3CloudAgent;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3CloudAgentDeploymentConfig;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3TemplateParameter;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3TemplateParameterDefinitionImpl;
import com.intellij.javaee.openshift.cloud.OS3ApplicationRuntime;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.javaee.openshift.cloud.deploymentSource.OS3LocalTemplateDeploymentSource;
import com.intellij.javaee.openshift.cloud.deploymentSource.OS3ServerTemplateDeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CallbackWrapper;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class OS3DeploymentRuntime
extends OS3ApplicationRuntime {
    private final OS3AgentDeployment myDeployment;
    private final DeploymentSource myDeplomentSource;

    public OS3DeploymentRuntime(ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor, OS3CloudAgent agent, final DeploymentTask<OSDeploymentConfiguration> task) {
        super(taskExecutor, agentTaskExecutor, ((OSDeploymentConfiguration)task.getConfiguration()).getTemplateName());
        this.myDeplomentSource = task.getSource();
        this.myDeployment = agent.createDeployment(new OS3CloudAgentDeploymentConfig(){

            public String getDeploymentName() {
                return ((OSDeploymentConfiguration)task.getConfiguration()).getDeploymentName();
            }

            public File getFile() {
                return task.getSource().getFile();
            }

            @Override
            public String getProjectName() {
                return ((OSDeploymentConfiguration)task.getConfiguration()).getProjectName();
            }

            @Override
            public String getTemplateName() {
                return ((OSDeploymentConfiguration)task.getConfiguration()).getTemplateName();
            }

            @Override
            public OS3TemplateParameter[] getTemplateParameters() {
                ArrayList result = new ArrayList();
                ((OSDeploymentConfiguration)task.getConfiguration()).getTemplateParameters().forEach(parameter -> result.add(new OS3TemplateParameter((OS3TemplateParameterDefinitionImpl)parameter){
                    final /* synthetic */ OS3TemplateParameterDefinitionImpl val$parameter;
                    {
                        this.val$parameter = oS3TemplateParameterDefinitionImpl;
                    }

                    @Override
                    public String getName() {
                        return this.val$parameter.getName();
                    }

                    @Override
                    public String getValue() {
                        return this.val$parameter.getValue();
                    }
                }));
                return result.toArray(new OS3TemplateParameter[result.size()]);
            }
        });
    }

    public void deploy(final ServerRuntimeInstance.DeploymentOperationCallback callback) {
        this.getAgentTaskExecutor().execute(() -> {
            if (this.myDeplomentSource instanceof OS3ServerTemplateDeploymentSource) {
                this.myDeployment.deployServerTemplate();
            }
            if (this.myDeplomentSource instanceof OS3LocalTemplateDeploymentSource) {
                this.myDeployment.deployLocalTemplate();
            }
            return null;
        }, new CallbackWrapper(){

            public void onSuccess(Object result) {
                Deployment deployment = callback.succeeded((DeploymentRuntime)OS3DeploymentRuntime.this);
                OS3DeploymentRuntime.this.setDeploymentModel(deployment);
            }

            public void onError(String message) {
                callback.errorOccurred(message);
            }
        });
    }

    @Override
    public void undeploy(@NotNull DeploymentRuntime.UndeploymentTaskCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/openshift/cloud/OS3DeploymentRuntime", "undeploy"));
        }
    }
}

