/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.openshift.agent.cloud.OSCloudAgentConfig;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3CloudAgent;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Pod;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Project;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3ProjectRequestConfig;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Service;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Template;
import com.intellij.javaee.openshift.cloud.OS3ApplicationRuntime;
import com.intellij.javaee.openshift.cloud.OS3DeploymentRuntime;
import com.intellij.javaee.openshift.cloud.OSCloudConfiguration;
import com.intellij.javaee.openshift.cloud.OSCloudType;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudAgentErrorHandler;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudAgentLoggingHandler;
import com.intellij.remoteServer.agent.util.CloudRemoteApplication;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.CloudApplicationRuntime;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class OS3ServerRuntimeInstance
extends CloudServerRuntimeInstance<OSDeploymentConfiguration, OS3CloudAgent, OSCloudConfiguration> {
    private static final Logger LOG = Logger.getInstance((String)("#" + OS3ServerRuntimeInstance.class.getName()));
    private static final String SPECIFICS_MODULE_NAME = "OpenShift3Srv";
    private static final String SPECIFICS_JAR_PATH = "specifics/openShiftSpecifics.jar";
    private static final String POD_STATUS_FAILED = "Failed";

    public OS3ServerRuntimeInstance(RemoteServer<OSCloudConfiguration> server, ServerTaskExecutor taskExecutor, List<File> clientLibrary) throws Exception {
        super((CloudAgentConfigBase)server.getConfiguration(), taskExecutor, clientLibrary, Collections.emptyList(), SPECIFICS_MODULE_NAME, SPECIFICS_JAR_PATH, OS3CloudAgent.class, "com.intellij.javaee.openshift.agent.cloud.OS3CloudAgentImpl");
    }

    protected CloudApplicationRuntime createApplicationRuntime(CloudRemoteApplication application) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source, OSDeploymentConfiguration configuration) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/javaee/openshift/cloud/OS3ServerRuntimeInstance", "getDeploymentName"));
        }
        String string = configuration.getTemplateName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/openshift/cloud/OS3ServerRuntimeInstance", "getDeploymentName"));
        }
        return string;
    }

    protected List<CloudApplicationRuntime> getApplications() throws ServerRuntimeException {
        return (List)this.getAgentTaskExecutor().execute(() -> {
            ArrayList<CloudApplicationRuntime> result = new ArrayList<CloudApplicationRuntime>();
            this.collectProjectsRuntime(result);
            return result;
        });
    }

    private void collectProjectsRuntime(List<CloudApplicationRuntime> result) {
        for (OS3Project project : ((OS3CloudAgent)this.getAgent()).getApplications()) {
            OS3ApplicationRuntime<OS3Project> projectRuntime = new OS3ApplicationRuntime<OS3Project>(this.getTaskExecutor(), this.getAgentTaskExecutor(), project, null, new DeploymentStatus(AllIcons.Actions.GroupByPackage, "Project", false));
            this.collectServices(result, project, projectRuntime);
            result.add(projectRuntime);
        }
    }

    private void collectServices(List<CloudApplicationRuntime> result, OS3Project project, OS3ApplicationRuntime projectRuntime) {
        for (OS3Service service : project.getServices()) {
            OS3ApplicationRuntime<OS3Service> serviceRuntime = new OS3ApplicationRuntime<OS3Service>(this.getTaskExecutor(), this.getAgentTaskExecutor(), service, projectRuntime, new DeploymentStatus(AllIcons.Actions.GroupByModuleGroup, "Service", false));
            result.add(serviceRuntime);
            this.collectPods(result, service, serviceRuntime);
        }
    }

    private void collectPods(List<CloudApplicationRuntime> result, OS3Service service, OS3ApplicationRuntime serviceRuntime) {
        for (OS3Pod pod : service.getPods()) {
            String podStatus = pod.getStatus();
            Icon statusIcon = podStatus != null && podStatus.contains(POD_STATUS_FAILED) ? AllIcons.General.BalloonError : AllIcons.Actions.GroupByModule;
            OS3PodApplicationRuntime podRuntime = new OS3PodApplicationRuntime(this.getTaskExecutor(), this.getAgentTaskExecutor(), pod, serviceRuntime, new DeploymentStatus(statusIcon, StringUtil.notNullize((String)podStatus, (String)"Pod"), false));
            result.add(podRuntime);
        }
    }

    public void createProject(final OS3ProjectRequestConfig config) {
        new RuntimeTask(){

            @Override
            protected void doPerform() {
                ((OS3CloudAgent)OS3ServerRuntimeInstance.this.getAgent()).createProject(config);
            }
        }.perform();
    }

    public void deploy(@NotNull DeploymentTask<OSDeploymentConfiguration> task, @NotNull DeploymentLogManager logManager, @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/javaee/openshift/cloud/OS3ServerRuntimeInstance", "deploy"));
        }
        if (logManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logManager", "com/intellij/javaee/openshift/cloud/OS3ServerRuntimeInstance", "deploy"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/openshift/cloud/OS3ServerRuntimeInstance", "deploy"));
        }
        this.getTaskExecutor().submit(() -> {
            if (task == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/javaee/openshift/cloud/OS3ServerRuntimeInstance", "lambda$deploy$1"));
            }
            if (callback == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/javaee/openshift/cloud/OS3ServerRuntimeInstance", "lambda$deploy$1"));
            }
            new OS3DeploymentRuntime(this.getTaskExecutor(), this.getAgentTaskExecutor(), (OS3CloudAgent)this.getAgent(), task).deploy(callback);
        }, (RemoteOperationCallback)callback);
    }

    public void disconnect() {
    }

    public void connect(ServerConnector.ConnectionCallback<OSDeploymentConfiguration> callback) {
        this.doConnect(callback);
    }

    private void doConnect(final ServerConnector.ConnectionCallback<OSDeploymentConfiguration> callback) {
        this.getAgentTaskExecutor().execute(() -> {
            ((OS3CloudAgent)this.getAgent()).connect((OSCloudAgentConfig)this.getConfiguration(), (CloudAgentErrorHandler)this.getAgentTaskExecutor(), new CloudAgentLogger(){

                public void debugEx(Exception e) {
                    LOG.debug((Throwable)e);
                }

                public void debug(String message) {
                    LOG.debug(message);
                }
            });
            return null;
        }, new CallbackWrapper(){

            public void onSuccess(Object result) {
                callback.connected((ServerRuntimeInstance)OS3ServerRuntimeInstance.this);
            }

            public void onError(String message) {
                callback.errorOccurred(message);
            }
        });
    }

    public List<OS3Template> getServerTemplates() throws ServerRuntimeException {
        return Arrays.asList((Object[])this.getAgentTaskExecutor().execute(() -> ((OS3CloudAgent)this.getAgent()).getServerTemplates()));
    }

    public List<OS3Project> getProjects() throws ServerRuntimeException {
        ArrayList<OS3Project> result = new ArrayList<OS3Project>();
        for (CloudApplicationRuntime applicationRuntime : this.getApplications()) {
            OS3ApplicationRuntime os3ApplicationRuntime = (OS3ApplicationRuntime)((Object)ObjectUtils.tryCast((Object)applicationRuntime, OS3ApplicationRuntime.class));
            assert (os3ApplicationRuntime != null);
            OS3Project project = (OS3Project)ObjectUtils.tryCast(os3ApplicationRuntime.getApplication(), OS3Project.class);
            if (project == null) continue;
            result.add(project);
        }
        return result;
    }

    public void uploadDescriptor(final String descriptor) {
        new RuntimeTask(){

            @Override
            protected void doPerform() {
                ((OS3CloudAgent)OS3ServerRuntimeInstance.this.getAgent()).uploadDescriptor(descriptor);
            }
        }.perform();
    }

    private abstract class RuntimeTask {
        private RuntimeTask() {
        }

        public void perform() {
            OS3ServerRuntimeInstance.this.getTaskExecutor().submit(() -> {
                try {
                    OS3ServerRuntimeInstance.this.getAgentTaskExecutor().execute(() -> {
                        this.doPerform();
                        return null;
                    });
                }
                catch (ServerRuntimeException e) {
                    new CloudNotifier(OSCloudType.getInstance().getPresentableName()).showMessage(e.getMessage(), MessageType.ERROR);
                }
            });
        }

        protected abstract void doPerform();
    }

    public static class OS3PodApplicationRuntime
    extends OS3ApplicationRuntime<OS3Pod> {
        public OS3PodApplicationRuntime(ServerTaskExecutor taskExecutor, AgentTaskExecutor agentTaskExecutor, OS3Pod pod, OS3ApplicationRuntime parent, DeploymentStatus status) {
            super(taskExecutor, agentTaskExecutor, pod, parent, status);
        }

        public void showLog(Project project, Runnable onDone) {
            new CloudApplicationRuntime.LoggingTask(){

                protected void run(CloudAgentLoggingHandler loggingHandler) {
                    ((OS3Pod)this.getApplication()).showLog(loggingHandler);
                }
            }.perform(project, onDone);
        }
    }
}

