/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.openshift.cloud;

import com.intellij.icons.AllIcons;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3Project;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3TemplateParameterDefinition;
import com.intellij.javaee.openshift.agent.cloud.os3.OS3TemplateParameterDefinitionImpl;
import com.intellij.javaee.openshift.cloud.OS3ServerRuntimeInstance;
import com.intellij.javaee.openshift.cloud.OSBundle;
import com.intellij.javaee.openshift.cloud.OSCloudConfiguration;
import com.intellij.javaee.openshift.cloud.OSDeploymentConfiguration;
import com.intellij.javaee.openshift.cloud.view.OS3TemplateParametersEditor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NotNull;

public abstract class TemplateDeploymentEditorBase
extends SettingsEditor<OSDeploymentConfiguration> {
    private String myStoredProjectName;
    private boolean myProjectsLoaded = false;
    private OS3TemplateParametersEditor myTemplateParametersEditor;
    private JTextArea myErrorMessageTextArea;

    protected void setupComponents() {
        this.setupErrorMessagePanel();
        this.getProjectsComboBox().setEnabled(false);
        this.getProjectsComboBox().addItem(this.getLoadingText());
        this.myTemplateParametersEditor = new OS3TemplateParametersEditor();
        this.getTemplateParametersEditorPlaceHolder().add(this.myTemplateParametersEditor.getPanel());
    }

    protected void setupErrorMessagePanel() {
        this.myErrorMessageTextArea = new JTextArea();
        this.myErrorMessageTextArea.setEditable(false);
        this.myErrorMessageTextArea.setOpaque(false);
        this.myErrorMessageTextArea.setLineWrap(true);
        this.getErrorMessagePlaceholder().add((Component)new JLabel(AllIcons.General.Error), "West");
        this.getErrorMessagePlaceholder().add((Component)this.myErrorMessageTextArea, "Center");
    }

    protected void setTemplateParameters(List<? extends OS3TemplateParameterDefinition> parameters) {
        this.myTemplateParametersEditor.setItems(ContainerUtil.map(parameters, OS3TemplateParameterDefinitionImpl::new));
    }

    protected List<OS3TemplateParameterDefinitionImpl> getTemplateParameters() {
        List<OS3TemplateParameterDefinitionImpl> items = this.myTemplateParametersEditor.getItems();
        return items == null ? Collections.emptyList() : ContainerUtil.map(items, OS3TemplateParameterDefinitionImpl::new);
    }

    protected void checkRequiredParameters() throws ConfigurationException {
        for (OS3TemplateParameterDefinitionImpl parameter : this.getTemplateParameters()) {
            if (!parameter.isRequired() || !StringUtil.isEmpty((String)parameter.getValue())) continue;
            throw new ConfigurationException(OSBundle.getText("OSDeploymentConfiguration.os3.parameter.required", parameter.getName()));
        }
    }

    private void loadProjects(@NotNull OS3ServerRuntimeInstance os3ServerRuntimeInstance) throws ServerRuntimeException {
        if (os3ServerRuntimeInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "os3ServerRuntimeInstance", "com/intellij/javaee/openshift/cloud/TemplateDeploymentEditorBase", "loadProjects"));
        }
        HashSet projectNames = new HashSet();
        os3ServerRuntimeInstance.getProjects().forEach(arg_0 -> TemplateDeploymentEditorBase.lambda$loadProjects$0((Set)projectNames, arg_0));
        ApplicationManager.getApplication().invokeLater(() -> this.lambda$loadProjects$2((Set)projectNames), ModalityState.any());
    }

    protected String getLoadingText() {
        return OSBundle.getText("OSDeploymentConfiguration.os3.state.loading", new Object[0]);
    }

    protected String getSelectedItem(JComboBox comboBox, String message) throws ConfigurationException {
        Object selectedItem = comboBox.getSelectedItem();
        if (selectedItem == null) {
            throw new ConfigurationException(OSBundle.getText("OSDeploymentConfiguration.os3.selection.required", message));
        }
        String selected = selectedItem.toString();
        if (StringUtil.isEmpty((String)selected) || StringUtil.equals((CharSequence)selected, (CharSequence)this.getLoadingText())) {
            throw new ConfigurationException(OSBundle.getText("OSDeploymentConfiguration.os3.selection.required", message));
        }
        return selected;
    }

    protected void showError(@NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/javaee/openshift/cloud/TemplateDeploymentEditorBase", "showError"));
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (errorMessage == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/javaee/openshift/cloud/TemplateDeploymentEditorBase", "lambda$showError$3"));
            }
            this.myErrorMessageTextArea.setText(errorMessage);
            this.getErrorMessagePlaceholder().setVisible(true);
        }, ModalityState.any());
    }

    protected final void loadServerData(RemoteServer<OSCloudConfiguration> server) {
        ServerConnection connection = ServerConnectionManager.getInstance().createTemporaryConnection(server);
        connection.connectIfNeeded(new ServerConnector.ConnectionCallback(){

            public void connected(@NotNull ServerRuntimeInstance serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverRuntimeInstance", "com/intellij/javaee/openshift/cloud/TemplateDeploymentEditorBase$1", "connected"));
                }
                OS3ServerRuntimeInstance os3ServerRuntimeInstance = (OS3ServerRuntimeInstance)serverRuntimeInstance;
                os3ServerRuntimeInstance.getTaskExecutor().submit(() -> {
                    try {
                        TemplateDeploymentEditorBase.this.doLoadServerData(os3ServerRuntimeInstance);
                    }
                    catch (ServerRuntimeException e) {
                        TemplateDeploymentEditorBase.this.showError(e.getMessage());
                    }
                });
            }

            public void errorOccurred(@NotNull String error) {
                if (error == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/javaee/openshift/cloud/TemplateDeploymentEditorBase$1", "errorOccurred"));
                }
                TemplateDeploymentEditorBase.this.showError(error);
            }
        });
    }

    protected void doLoadServerData(OS3ServerRuntimeInstance os3ServerRuntimeInstance) throws ServerRuntimeException {
        this.loadProjects(os3ServerRuntimeInstance);
    }

    protected String getStoredProjectName() {
        return this.myStoredProjectName;
    }

    protected void setStoredProjectName(String storedProjectName) {
        this.myStoredProjectName = storedProjectName;
    }

    protected final boolean areProjectsLoaded() {
        return this.myProjectsLoaded;
    }

    protected abstract void updateLoadingState();

    protected abstract JComboBox<String> getProjectsComboBox();

    protected abstract JPanel getErrorMessagePlaceholder();

    protected abstract JPanel getTemplateParametersEditorPlaceHolder();

    private /* synthetic */ void lambda$loadProjects$2(Set projectNames) {
        this.getProjectsComboBox().removeAllItems();
        projectNames.forEach(projectName -> this.getProjectsComboBox().addItem((String)projectName));
        this.myProjectsLoaded = true;
        this.updateLoadingState();
        if (!StringUtil.isEmpty((String)this.getStoredProjectName())) {
            this.getProjectsComboBox().setSelectedItem(this.getStoredProjectName());
        }
    }

    private static /* synthetic */ void lambda$loadProjects$0(Set projectNames, OS3Project project) {
        projectNames.add(project.getName());
    }
}

