/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.firefox;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.MessageDecoder;
import org.jetbrains.rpc.CommandProcessorKt;

public abstract class FirefoxMessageDecoder
extends MessageDecoder {
    private State state = State.LENGTH;

    protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) throws Exception {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/firefox/FirefoxMessageDecoder", "messageReceived"));
        }
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/firefox/FirefoxMessageDecoder", "messageReceived"));
        }
        while (true) {
            switch (this.state) {
                case LENGTH: {
                    if (!FirefoxMessageDecoder.readUntil((char)':', (ByteBuf)input, (StringBuilder)this.builder)) {
                        return;
                    }
                    this.state = State.CONTENT;
                    this.contentLength = this.parseContentLength();
                    this.builder.setLength(0);
                }
                case CONTENT: {
                    CharSequence result = this.readChars(input);
                    if (result == null) {
                        return;
                    }
                    if (CommandProcessorKt.getLOG().isDebugEnabled()) {
                        CommandProcessorKt.getLOG().debug("IN: " + result);
                    }
                    this.contentLength = 0;
                    this.state = State.LENGTH;
                    this.processMessage(result, context);
                }
            }
        }
    }

    protected abstract void processMessage(@NotNull CharSequence var1, @NotNull ChannelHandlerContext var2);

    private static enum State {
        LENGTH,
        CONTENT;

    }
}

