/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.model.common.ejb;

import com.intellij.javaee.ejb.EjbHelper;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.role.EjbClassRole;
import com.intellij.javaee.ejb.role.EjbClassRoleEnum;
import com.intellij.javaee.model.common.ejb.EjbWithHome;
import com.intellij.javaee.model.common.ejb.EnterpriseBean;
import com.intellij.javaee.model.common.ejb.Interceptor;
import com.intellij.javaee.model.common.ejb.MessageDrivenBean;
import com.intellij.javaee.model.common.ejb.SessionBean;
import com.intellij.javaee.model.xml.ejb.EjbBase;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EjbCommonModelUtil {
    public static <T> List<T> collectEjbClasses(EnterpriseBean ejb, boolean includeClass, boolean includeHomeInterfaces, boolean includeComponentInterfaces, Function<Pair<GenericValue<PsiClass>, EjbClassRoleEnum>, T> mapper) {
        ArrayList result = new ArrayList();
        if (includeClass) {
            ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(ejb.getEjbClass(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS))));
        }
        if (ejb instanceof EjbWithHome) {
            EjbWithHome ejbWithHome = (EjbWithHome)ejb;
            if (includeHomeInterfaces) {
                ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(ejbWithHome.getHome(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_HOME_INTERFACE))));
                ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(ejbWithHome.getLocalHome(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_HOME_INTERFACE))));
            }
            if (includeComponentInterfaces) {
                ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(ejbWithHome.getRemote(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_REMOTE_INTERFACE))));
                ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(ejbWithHome.getLocal(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE))));
                if (ejb instanceof SessionBean) {
                    SessionBean sessionBean = (SessionBean)ejb;
                    if (Boolean.TRUE.equals(sessionBean.getLocalBean().getValue())) {
                        ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(sessionBean.getEjbClass(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_EJB_CLASS))));
                    } else {
                        for (GenericValue<PsiClass> genericValue : sessionBean.getBusinessLocals()) {
                            ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(genericValue, (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_LOCAL_INTERFACE))));
                        }
                        for (GenericValue<PsiClass> genericValue : sessionBean.getBusinessRemotes()) {
                            ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(genericValue, (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_BUSINESS_REMOTE_INTERFACE))));
                        }
                        ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(sessionBean.getServiceEndpoint(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_SERVICE_ENDPOINT_INTERFACE))));
                    }
                }
            }
        }
        if (includeComponentInterfaces && ejb instanceof MessageDrivenBean) {
            ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)Pair.create(((MessageDrivenBean)ejb).getMessageListenerInterface(), (Object)((Object)EjbClassRoleEnum.EJB_CLASS_ROLE_LOCAL_INTERFACE))));
        }
        return result;
    }

    public static List<GenericValue<PsiClass>> getEjbClassesReferences(EnterpriseBean ejb, boolean includeClass, boolean includeHomeInterfaces, boolean includeComponentInterfaces) {
        return EjbCommonModelUtil.collectEjbClasses(ejb, includeClass, includeHomeInterfaces, includeComponentInterfaces, s -> (GenericValue)s.getFirst());
    }

    public static List<PsiClass> getEjbClasses(EnterpriseBean ejb, boolean includeClass, boolean includeHomeInterfaces, boolean includeComponentInterfaces) {
        return EjbCommonModelUtil.collectEjbClasses(ejb, includeClass, includeHomeInterfaces, includeComponentInterfaces, s -> (PsiClass)((GenericValue)s.getFirst()).getValue());
    }

    @NotNull
    public static <T, V extends Collection<T>> V mapEjbClassRoles(@NotNull V result, @NotNull Project project, @Nullable Module module, @Nullable EjbFacet facet, @NotNull Function<EjbClassRole, T> mapper) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/javaee/model/common/ejb/EjbCommonModelUtil", "mapEjbClassRoles"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/model/common/ejb/EjbCommonModelUtil", "mapEjbClassRoles"));
        }
        if (mapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapper", "com/intellij/javaee/model/common/ejb/EjbCommonModelUtil", "mapEjbClassRoles"));
        }
        for (EjbClassRole role : EjbHelper.getEjbHelper().getAllEjbRoles(project)) {
            if (module != null && module != role.getModule() || facet != null && facet != role.getFacet()) continue;
            ContainerUtil.addIfNotNull(result, (Object)mapper.fun((Object)role));
        }
        V v = result;
        if (v == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/common/ejb/EjbCommonModelUtil", "mapEjbClassRoles"));
        }
        return v;
    }

    @NotNull
    public static List<Interceptor> getAllInterceptors(@NotNull Project project, @Nullable Module module, @Nullable EjbFacet facet) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/model/common/ejb/EjbCommonModelUtil", "getAllInterceptors"));
        }
        List list = EjbCommonModelUtil.mapEjbClassRoles(new ArrayList(), project, module, facet, ejbClassRole -> ejbClassRole.getInterceptor());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/common/ejb/EjbCommonModelUtil", "getAllInterceptors"));
        }
        return list;
    }

    @NotNull
    public static List<EnterpriseBean> getAllEjbs(@NotNull Project project, @Nullable Module module, @Nullable EjbFacet facet) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/model/common/ejb/EjbCommonModelUtil", "getAllEjbs"));
        }
        List list = EjbCommonModelUtil.mapEjbClassRoles(new ArrayList(), project, module, facet, ejbClassRole -> ejbClassRole.getEnterpriseBean());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/common/ejb/EjbCommonModelUtil", "getAllEjbs"));
        }
        return list;
    }

    public static List<EnterpriseBean> getAllEjbs(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/model/common/ejb/EjbCommonModelUtil", "getAllEjbs"));
        }
        return EjbCommonModelUtil.getAllEjbs(project, null, null);
    }

    @NotNull
    public static EnterpriseBean getMergedEnterpriseBean(@NotNull EjbBase base) {
        EnterpriseBean bean;
        if (base == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "base", "com/intellij/javaee/model/common/ejb/EjbCommonModelUtil", "getMergedEnterpriseBean"));
        }
        Module module = base.getModule();
        if (module != null && (bean = (EnterpriseBean)ElementPresentationManager.findByName(EjbCommonModelUtil.getAllEjbs(module.getProject(), module, null), (String)((String)base.getEjbName().getValue()))) != null) {
            EnterpriseBean enterpriseBean = bean;
            if (enterpriseBean == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/common/ejb/EjbCommonModelUtil", "getMergedEnterpriseBean"));
            }
            return enterpriseBean;
        }
        EjbBase ejbBase = base;
        if (ejbBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/model/common/ejb/EjbCommonModelUtil", "getMergedEnterpriseBean"));
        }
        return ejbBase;
    }
}

