/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.library;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PatternCondition;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootLibraryUtil {
    public static final PatternCondition<PsiElement> SB_1_3_OR_HIGHER = new PatternCondition<PsiElement>("SB1_3OrHigher"){

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/library/SpringBootLibraryUtil$1", "accepts"));
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
            return SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootVersion.VERSION_1_3_0);
        }
    };

    public static boolean hasConfigurationMetadataAnnotationProcessor(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/library/SpringBootLibraryUtil", "hasConfigurationMetadataAnnotationProcessor"));
        }
        PsiClass processor = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.configurationprocessor.ConfigurationMetadataAnnotationProcessor");
        return processor != null;
    }

    public static boolean hasSpringBootLibrary(Project project) {
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            DumbService dumbService = DumbService.getInstance((Project)project);
            if (dumbService.isDumb()) {
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{dumbService.getModificationTracker()});
            }
            boolean foundMarkerClass = JavaPsiFacade.getInstance((Project)project).findClass(SpringBootVersion.ANY.getDetectionClassFqn(), ProjectScope.getLibrariesScope((Project)project)) != null;
            return CachedValueProvider.Result.createSingleDependency((Object)foundMarkerClass, (Object)ProjectRootManager.getInstance((Project)project));
        });
    }

    public static boolean hasSpringBootLibrary(@Nullable Module module) {
        return SpringBootLibraryUtil.isAtLeastVersion(module, SpringBootVersion.ANY);
    }

    public static boolean isAtLeastVersion(@Nullable Module module, SpringBootVersion version) {
        if (module == null) {
            return false;
        }
        if (!SpringBootLibraryUtil.hasSpringBootLibrary(module.getProject())) {
            return false;
        }
        SpringBootVersion cached = SpringBootLibraryUtil.getCachedSpringBootVersion(module);
        return cached != null && cached.isAtLeast(version);
    }

    @Nullable
    public static String getVersionFromJar(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/library/SpringBootLibraryUtil", "getVersionFromJar"));
        }
        return JarVersionDetectionUtil.detectJarVersion((String)SpringBootVersion.ANY.getDetectionClassFqn(), (Module)module);
    }

    public static boolean hasDevtools(@Nullable Module module) {
        return SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.boot.devtools.RemoteSpringApplication") != null;
    }

    @Nullable
    private static SpringBootVersion getCachedSpringBootVersion(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/library/SpringBootLibraryUtil", "getCachedSpringBootVersion"));
        }
        Project project = module.getProject();
        return (SpringBootVersion)((Object)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/boot/library/SpringBootLibraryUtil", "lambda$getCachedSpringBootVersion$1"));
            }
            GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false);
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)project);
            SpringBootVersion detected = null;
            for (SpringBootVersion version : (SpringBootVersion[])ArrayUtil.reverseArray((Object[])SpringBootVersion.values())) {
                PsiClass psiClass = javaPsiFacade.findClass(version.getDetectionClassFqn(), scope);
                if (psiClass == null) continue;
                detected = version;
                break;
            }
            return CachedValueProvider.Result.create(detected, (Object[])new Object[]{ProjectRootManager.getInstance((Project)project)});
        }));
    }

    public static enum SpringBootVersion {
        ANY("1.0", "org.springframework.boot.SpringApplication"),
        VERSION_1_2_0("1.2.0", "org.springframework.boot.jta.XADataSourceWrapper"),
        VERSION_1_3_0("1.3.0", "org.springframework.boot.context.event.ApplicationReadyEvent"),
        VERSION_1_4_0("1.4.0", "org.springframework.boot.diagnostics.FailureAnalysis"),
        VERSION_1_5_0("1.5.0", "org.springframework.boot.autoconfigure.AbstractDatabaseInitializer"),
        VERSION_2_0_0("2.0.0", "org.springframework.boot.WebApplicationType");

        private final String myVersion;
        private final String myDetectionClassFqn;

        private SpringBootVersion(String version, String detectionClassFqn) {
            this.myVersion = version;
            this.myDetectionClassFqn = detectionClassFqn;
        }

        boolean isAtLeast(SpringBootVersion reference) {
            if (reference == ANY) {
                return true;
            }
            return StringUtil.compareVersionNumbers((String)this.getVersion(), (String)reference.getVersion()) >= 0;
        }

        String getVersion() {
            return this.myVersion;
        }

        public String getDetectionClassFqn() {
            return this.myDetectionClassFqn;
        }
    }
}

