/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.DashboardNode;
import com.intellij.execution.dashboard.DashboardRunConfigurationNode;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.ui.SimpleTextAttributes;

public class SpringBootApplicationRunDashboardContributor
extends RunDashboardContributor {
    public SpringBootApplicationRunDashboardContributor() {
        super((ConfigurationType)SpringBootApplicationConfigurationTypeBase.getInstance());
    }

    public void updatePresentation(PresentationData presentation, DashboardNode node) {
        SpringBootApplicationInfo info;
        RunConfiguration runConfiguration;
        if (!(node instanceof DashboardRunConfigurationNode)) {
            return;
        }
        DashboardRunConfigurationNode runConfigurationNode = (DashboardRunConfigurationNode)node;
        if (!DumbService.getInstance((Project)runConfigurationNode.getProject()).isDumb() && (runConfiguration = runConfigurationNode.getConfigurationSettings().getConfiguration()) instanceof SpringBootApplicationRunConfiguration && SpringBootLibraryUtil.hasDevtools((Module)((SpringBootApplicationRunConfiguration)runConfiguration).getModule())) {
            presentation.addText(" [devtools]", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if ((info = SpringBootApplicationRunDashboardContributor.getInfo(runConfigurationNode)) != null) {
            int serverPort;
            if (!info.isReady()) {
                presentation.setIcon(AllIcons.Process.Step_4);
            }
            if ((serverPort = info.getServerPort()) > 0) {
                presentation.addText(" [:" + serverPort + "]", SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
        }
    }

    private static SpringBootApplicationInfo getInfo(DashboardRunConfigurationNode node) {
        ProcessHandler handler;
        RunContentDescriptor descriptor = node.getDescriptor();
        if (descriptor != null && descriptor.getProcessHandler() != null && !(handler = descriptor.getProcessHandler()).isProcessTerminated()) {
            return SpringBootApplicationLifecycleManager.getInstance((Project)node.getProject()).getInfo(handler);
        }
        return null;
    }
}

