/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.editor;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.spring.SpringManager;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.editor.SpringBootAdditionalParamsTableView;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.TableUtil;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.SpringApiIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import org.jetbrains.annotations.Nullable;

public class SpringBootSettingsPanel
extends JPanel
implements PanelWithAnchor {
    private JPanel myRootPanel;
    private JComponent myAnchor;
    private JBCheckBox myEnableDebugOutput;
    private JBCheckBox myEnableLaunchOptimization;
    private JBCheckBox myHideBanner;
    private JPanel myAdditionalParametersPanel;
    private LabeledComponent<TextFieldWithAutoCompletion<String>> myActiveProfiles;
    private JLabel myDevToolsMessage;
    private SpringBootAdditionalParamsTableView myAdditionalParamsTable;
    private final Project myProject;
    private Module myModule;

    public SpringBootSettingsPanel(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.initAdditionalParamsTable();
        if (Registry.is((String)"compiler.automake.allow.when.app.running")) {
            this.myDevToolsMessage.setIcon(AllIcons.RunConfigurations.ConfigurationWarning);
            this.myDevToolsMessage.setText("Background compilation enabled");
        }
    }

    private void initAdditionalParamsTable() {
        this.myAdditionalParamsTable = new SpringBootAdditionalParamsTableView();
        this.myAdditionalParametersPanel.add((Component)ToolbarDecorator.createDecorator((JTable)((Object)this.myAdditionalParamsTable)).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                SpringBootSettingsPanel.this.myAdditionalParamsTable.addAdditionalParameter();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                TableUtil.removeSelectedItems((JTable)((Object)SpringBootSettingsPanel.this.myAdditionalParamsTable));
            }
        }).createPanel(), "Center");
    }

    boolean isEnableDebugOutput() {
        return this.myEnableDebugOutput.isSelected();
    }

    void setEnableDebugOutput(boolean value) {
        this.myEnableDebugOutput.setSelected(value);
    }

    boolean isEnableLaunchOptimization() {
        return this.myEnableLaunchOptimization.isSelected();
    }

    void setEnableLaunchOptimization(boolean value) {
        this.myEnableLaunchOptimization.setSelected(value);
    }

    boolean isHideBanner() {
        return this.myHideBanner.isSelected();
    }

    void setHideBanner(boolean value) {
        this.myHideBanner.setSelected(value);
    }

    void setAdditionalParameters(List<SpringBootAdditionalParameter> parameters) {
        this.myAdditionalParamsTable.setAdditionalParameters(parameters);
    }

    List<SpringBootAdditionalParameter> getAdditionalParameters() {
        return this.myAdditionalParamsTable.getAdditionalParameters();
    }

    String getActiveProfiles() {
        return ((TextFieldWithAutoCompletion)this.myActiveProfiles.getComponent()).getText();
    }

    void setActiveProfiles(String value) {
        ((TextFieldWithAutoCompletion)this.myActiveProfiles.getComponent()).setText(value);
    }

    public JComponent getAnchor() {
        return this.myAnchor;
    }

    public void setAnchor(@Nullable JComponent anchor) {
        this.myAnchor = anchor;
        this.myActiveProfiles.setAnchor(anchor);
    }

    public void stopEditing() {
        this.myAdditionalParamsTable.stopEditing();
    }

    public void setModule(Module module) {
        this.myModule = module;
        this.myAdditionalParamsTable.setModule(module);
        this.updateProfilesCompletion();
    }

    private void updateProfilesCompletion() {
        if (this.myModule == null) {
            ((TextFieldWithAutoCompletion)this.myActiveProfiles.getComponent()).setVariants(Collections.emptyList());
            return;
        }
        SpringModel model = SpringManager.getInstance((Project)this.myProject).getCombinedModel(this.myModule);
        ArrayList allProfileNames = new ArrayList(model.getAllProfiles());
        allProfileNames.remove("_DEFAULT_PROFILE_NAME_");
        Collections.sort(allProfileNames);
        ((TextFieldWithAutoCompletion)this.myActiveProfiles.getComponent()).setVariants(allProfileNames);
    }

    private void createUIComponents() {
        TextFieldWithAutoCompletion field = TextFieldWithAutoCompletion.create((Project)this.myProject, Collections.emptyList(), (Icon)SpringApiIcons.SpringProfile, (boolean)true, (String)"");
        this.myActiveProfiles = LabeledComponent.create((JComponent)field, (String)"Active Profiles");
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JLabel jLabel;
        JPanel jPanel;
        JBCheckBox jBCheckBox3;
        JPanel jPanel2;
        this.createUIComponents();
        this.myRootPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Spring Boot Settings", (int)1, (int)0, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 5, 0, 2, 1, 6, null, null, null));
        this.myEnableDebugOutput = jBCheckBox3 = new JBCheckBox();
        jBCheckBox3.setText("Enable debug output");
        jBCheckBox3.setMnemonic('D');
        jBCheckBox3.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myAdditionalParametersPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 5, 0, 3, 3, 3, null, null, null, 1));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)"Override parameters", (int)0, (int)0, null, null));
        LabeledComponent<TextFieldWithAutoCompletion<String>> labeledComponent = this.myActiveProfiles;
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText("Active Profiles");
        jPanel2.add((Component)labeledComponent, new GridConstraints(1, 0, 1, 5, 0, 1, 3, 3, null, null, null));
        this.myDevToolsMessage = jLabel = new JLabel();
        jLabel.setText("");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 3, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEnableLaunchOptimization = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Add VM options for launch optimization");
        jBCheckBox2.setMnemonic('L');
        jBCheckBox2.setDisplayedMnemonicIndex(19);
        jBCheckBox2.setToolTipText("Add VM options -XX:TieredStopAtLevel=1 and -noverify to speed up startup");
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(0, 2, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myHideBanner = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Hide Banner");
        jBCheckBox.setMnemonic('H');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBCheckBox, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }
}

