/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.spring.boot.run.lifecycle.SpringBootJmxConnector;
import javax.management.InstanceNotFoundException;

class SpringBootApplicationConnector
extends SpringBootJmxConnector {
    private static final String SPRING_BOOT_APPLICATION_OBJECT_NAME = "org.springframework.boot:type=Admin,name=SpringApplication";
    private static final String READY_ATTR = "Ready";
    private static final String GET_PROPERTY_OPERATION = "getProperty";
    private static final String LOCAL_SERVER_PORT_PROPERTY = "local.server.port";

    public SpringBootApplicationConnector(int jmxPort) {
        super(jmxPort, SPRING_BOOT_APPLICATION_OBJECT_NAME);
    }

    Object getProperty(String propertyName) throws Exception {
        return this.getJmxConnection().invoke(this.getObjectName(), GET_PROPERTY_OPERATION, new String[]{propertyName}, new String[]{String.class.getName()});
    }

    int getServerPort() throws Exception {
        Object value = this.getProperty(LOCAL_SERVER_PORT_PROPERTY);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    boolean isReady() throws Exception {
        try {
            Object value = this.getJmxConnection().getAttribute(this.getObjectName(), READY_ATTR);
            return value instanceof Boolean ? (Boolean)value : false;
        }
        catch (InstanceNotFoundException ex) {
            return false;
        }
    }
}

