/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.dashboard.DashboardListener;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.run.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationConnector;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class SpringBootApplicationInfoImpl
implements SpringBootApplicationInfo {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfoImpl");
    private static final long STATE_CHECKING_RETRY_INTERVAL = 500L;
    private static final long SERVER_PORT_RETRY_INTERVAL = 100L;
    private static final int SERVER_PORT_RETRY_COUNT = 10;
    @NotNull
    private final Project myProject;
    private final int myJmxPort;
    private volatile boolean myDisposed;
    private volatile int myServerPort;
    private volatile boolean myReady;

    public static SpringBootApplicationInfo createInfo(@NotNull Project project, int jmxPort) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "createInfo"));
        }
        SpringBootApplicationInfoImpl info = new SpringBootApplicationInfoImpl(project, jmxPort);
        info.startReadyStateChecker();
        return info;
    }

    private SpringBootApplicationInfoImpl(@NotNull Project project, int jmxPort) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationInfoImpl", "<init>"));
        }
        this.myDisposed = false;
        this.myServerPort = -1;
        this.myReady = false;
        LOG.assertTrue(jmxPort > 0);
        this.myProject = project;
        this.myJmxPort = jmxPort;
    }

    public boolean isReady() {
        return this.myReady;
    }

    public int getServerPort() {
        return this.myServerPort;
    }

    public void dispose() {
        this.myDisposed = true;
    }

    private void startReadyStateChecker() {
        Runnable checker = new Runnable(){

            @Override
            public void run() {
                if (SpringBootApplicationInfoImpl.this.myDisposed || SpringBootApplicationInfoImpl.this.myReady) {
                    return;
                }
                try (SpringBootApplicationConnector connector = new SpringBootApplicationConnector(SpringBootApplicationInfoImpl.this.myJmxPort);){
                    if (connector.isReady()) {
                        SpringBootApplicationInfoImpl.this.myReady = true;
                        ((DashboardListener)SpringBootApplicationInfoImpl.this.myProject.getMessageBus().syncPublisher(RunDashboardManager.DASHBOARD_TOPIC)).contentChanged(true);
                        SpringBootApplicationInfoImpl.this.retrievePort();
                        return;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JobScheduler.getScheduler().schedule(this, 500L, TimeUnit.MILLISECONDS);
            }
        };
        JobScheduler.getScheduler().submit(checker);
    }

    private void retrievePort() {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (this.myDisposed) {
                return;
            }
            SpringBootApplicationConnector connector = new SpringBootApplicationConnector(this.myJmxPort);
            Throwable throwable = null;
            try {
                Exception lastThrownException = null;
                int i = 0;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            catch (Throwable throwable3) {
                throw throwable3;
            }
        });
    }
}

