/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.spring.boot.run.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfoImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBootApplicationLifecycleManagerImpl
implements SpringBootApplicationLifecycleManager,
Disposable {
    private final Project myProject;
    private final Map<ProcessHandler, SpringBootApplicationInfo> myInfos = new ConcurrentHashMap<ProcessHandler, SpringBootApplicationInfo>();

    public SpringBootApplicationLifecycleManagerImpl(Project project) {
        this.myProject = project;
        this.init();
        Disposer.register((Disposable)project, (Disposable)this);
    }

    private void init() {
        if (!Registry.is((String)"ide.run.dashboard") || !Registry.is((String)"ide.run.dashboard.spring.boot.jmx")) {
            return;
        }
        this.myProject.getMessageBus().connect((Disposable)this.myProject).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                if (executorId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1", "processStarted"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1", "processStarted"));
                }
                if (handler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1", "processStarted"));
                }
                RunnerAndConfigurationSettings configurationSettings = env.getRunnerAndConfigurationSettings();
                if (configurationSettings == null) {
                    return;
                }
                if (configurationSettings.getConfiguration() instanceof SpringBootApplicationRunConfiguration) {
                    Integer jmxPort = (Integer)handler.getUserData(SpringBootApplicationLifecycleManager.JMX_PORT);
                    if (jmxPort == null || jmxPort <= 0) {
                        return;
                    }
                    SpringBootApplicationInfo info = SpringBootApplicationInfoImpl.createInfo(SpringBootApplicationLifecycleManagerImpl.this.myProject, jmxPort);
                    Disposer.register((Disposable)SpringBootApplicationLifecycleManagerImpl.this, (Disposable)info);
                    SpringBootApplicationLifecycleManagerImpl.this.myInfos.put(handler, info);
                }
            }

            public void processTerminated(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler, int exitCode) {
                if (executorId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1", "processTerminated"));
                }
                if (env == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "env", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1", "processTerminated"));
                }
                if (handler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1", "processTerminated"));
                }
                SpringBootApplicationInfo info = (SpringBootApplicationInfo)SpringBootApplicationLifecycleManagerImpl.this.myInfos.remove(handler);
                if (info != null) {
                    Disposer.dispose((Disposable)info);
                }
            }
        });
    }

    public void dispose() {
        this.myInfos.clear();
    }

    @Nullable
    public SpringBootApplicationInfo getInfo(ProcessHandler handler) {
        return this.myInfos.get(handler);
    }
}

