/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeInsight.completion.ExtendedTagInsertHandler;
import com.intellij.codeInspection.JspInspectionGroupNames;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlNamespaceHelper;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractWrapFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = JspInspectionGroupNames.JSP_INSPECTIONS;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/AbstractWrapFix", "getFamilyName"));
        }
        return string;
    }

    protected abstract String getNamespace();

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/jsp/AbstractWrapFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/jsp/AbstractWrapFix", "applyFix"));
        }
        final PsiElement element = descriptor.getPsiElement();
        JspFile jsp = JspPsiUtil.getJspFile((PsiElement)element);
        XmlTag rootTag = jsp.getRootTag();
        String prefix = rootTag.getPrefixByNamespace(this.getNamespace());
        if (StringUtil.isEmpty((String)prefix)) {
            prefix = ExtendedTagInsertHandler.suggestPrefix((XmlFile)jsp, (String)this.getNamespace());
            XmlNamespaceHelper extension = XmlNamespaceHelper.getHelper((PsiFile)jsp);
            extension.insertNamespaceDeclaration((XmlFile)jsp, null, Collections.singleton(this.getNamespace()), prefix, (XmlNamespaceHelper.Runner)new XmlNamespaceHelper.Runner<String, IncorrectOperationException>(){

                public void run(String param) throws IncorrectOperationException {
                    AbstractWrapFix.this.wrapValue(param, element);
                }
            });
        } else {
            this.wrapValue(prefix, element);
        }
    }

    protected void wrapValue(String prefix, PsiElement element) throws IllegalArgumentException {
        element = this.getElementToReplace(element);
        JspFile jsp = JspPsiUtil.getJspFile((PsiElement)element);
        Project project = jsp.getProject();
        String text = ElementManipulators.getValueText((PsiElement)element);
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element).shiftRight(element.getTextRange().getStartOffset());
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)jsp);
        PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        StringBuilder builder = this.buildNewText(prefix, text);
        document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)builder.toString());
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
    }

    protected PsiElement getElementToReplace(PsiElement holder) {
        return holder;
    }

    protected abstract StringBuilder buildNewText(String var1, String var2);
}

