/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.findUsages.PropertySearcher;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.impl.source.jsp.JspManagerImpl;
import com.intellij.psi.impl.source.jsp.TaglibIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertyReferenceViaLastWordSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters>
implements PropertySearcher {
    public PropertyReferenceViaLastWordSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters queryParameters, @NotNull Processor<PsiReference> consumer) {
        if (queryParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queryParameters", "com/intellij/psi/impl/search/PropertyReferenceViaLastWordSearcher", "processQuery"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/psi/impl/search/PropertyReferenceViaLastWordSearcher", "processQuery"));
        }
        PsiElement refElement = queryParameters.getElementToSearch();
        if (!(refElement instanceof IProperty)) {
            return;
        }
        String name = ((IProperty)refElement).getName();
        if (name == null) {
            return;
        }
        Project project = refElement.getProject();
        String lastWord = this.getKeyToSearch(name, project);
        if (lastWord == null) {
            return;
        }
        boolean relevant = PropertyReferenceViaLastWordSearcher.isRelevantForProject(project);
        if (!relevant) {
            return;
        }
        SearchScope searchScope = queryParameters.getEffectiveSearchScope();
        if (searchScope instanceof GlobalSearchScope) {
            searchScope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)((GlobalSearchScope)searchScope), (FileType[])new FileType[]{StdFileTypes.JSP, StdFileTypes.JSPX});
        }
        queryParameters.getOptimizer().searchWord(lastWord, searchScope, (short)8, false, refElement);
    }

    static boolean isRelevantForProject(Project project) {
        return PropertyReferenceViaLastWordSearcher.findNamespace("http://java.sun.com/jsp/jstl/fmt", project) || PropertyReferenceViaLastWordSearcher.findNamespace("http://java.sun.com/jstl/fmt", project);
    }

    private static boolean findNamespace(String namespace, Project project) {
        return !FileBasedIndex.getInstance().processValues(TaglibIndex.NAME, (Object)namespace, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<TaglibIndex.TaglibInfo>(){

            public boolean process(VirtualFile file, TaglibIndex.TaglibInfo value) {
                return false;
            }
        }, GlobalSearchScope.allScope((Project)project));
    }

    @Nullable
    public String getKeyToSearch(String propertyName, Project project) {
        if (!((JspManagerImpl)JspManager.getInstance((Project)project)).getState().searchForPrefixedReferences) {
            return propertyName;
        }
        List words = StringUtil.getWordsIn((String)propertyName);
        if (words.isEmpty()) {
            return null;
        }
        return (String)words.get(words.size() - 1);
    }
}

