/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.codeInsight.daemon.quickFix.TagFileQuickFixProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.jsp.jspXml.JspDirective;
import com.intellij.psi.impl.source.xml.TagNameReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlUndefinedElementFixProvider;
import java.util.ArrayList;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspTagNameReference
extends TagNameReference
implements LocalQuickFixProvider {
    @NonNls
    protected static final String TAG_EXTENSION = ".tag";
    @NonNls
    protected static final String TAGX_EXTENSION = ".tagx";

    public JspTagNameReference(ASTNode nameElement, boolean startTagFlag) {
        super(nameElement, startTagFlag);
    }

    @Nullable
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        XmlTag element = this.getTagElement();
        if (element == null) {
            return null;
        }
        if ((newElementName.endsWith(TAG_EXTENSION) || newElementName.endsWith(TAGX_EXTENSION)) && JspPsiUtil.isInJspFile((PsiElement)element)) {
            newElementName = newElementName.substring(0, newElementName.lastIndexOf(46));
        }
        return super.handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/JspTagNameReference", "bindToElement"));
        }
        if (element instanceof PsiFile && JspPsiUtil.isInJspFile((PsiElement)element)) {
            return this.getElement();
        }
        return super.bindToElement(element);
    }

    @NotNull
    public Object[] getVariants() {
        PsiElement element = this.getElement();
        if (element instanceof JspDirective) {
            if (LookupElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspTagNameReference", "getVariants"));
            }
            return LookupElement.EMPTY_ARRAY;
        }
        if (!this.myStartTagFlag) {
            if (LookupElement.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspTagNameReference", "getVariants"));
            }
            return LookupElement.EMPTY_ARRAY;
        }
        Object[] objectArray = super.getVariants();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspTagNameReference", "getVariants"));
        }
        return objectArray;
    }

    @Nullable
    public LocalQuickFix[] getQuickFixes() {
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)this.getElement(), XmlTag.class, (boolean)false);
        if (tag != null) {
            LocalQuickFix action;
            ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
            for (XmlUndefinedElementFixProvider fixProvider : (XmlUndefinedElementFixProvider[])Extensions.getExtensions((ExtensionPointName)XmlUndefinedElementFixProvider.EP_NAME)) {
                LocalQuickFix[] fixes = fixProvider.createFixes(tag);
                if (fixes == null) continue;
                Collections.addAll(result, fixes);
                break;
            }
            if (result.isEmpty() && (action = TagFileQuickFixProvider.createTagFileReferenceQuickFix(tag)) != null) {
                result.add(action);
            }
            return result.toArray(new LocalQuickFix[result.size()]);
        }
        return LocalQuickFix.EMPTY_ARRAY;
    }
}

