/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp;

import com.intellij.codeInsight.daemon.impl.quickfix.EmptyExpression;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.jsp.JspBundle;
import com.intellij.jsp.impl.TldDescriptor;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.jsp.JspxFileViewProvider;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.jsp.JspManager;
import com.intellij.psi.jsp.JspDirectiveKind;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.el.ELFunctionCallExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlNamespaceHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspXmlNamespaceHelper
extends XmlNamespaceHelper {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.jsp.JspXmlNamespaceHelper");
    @NonNls
    private static final String URI_ATTR_NAME = "uri";

    private static void insertTaglibDeclaration(XmlFile file, @Nullable Editor editor, @NotNull String namespace, @NotNull String prefix) throws IncorrectOperationException {
        XmlAttribute xmlAttribute;
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "insertTaglibDeclaration"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "insertTaglibDeclaration"));
        }
        Project project = file.getProject();
        XmlDocument document = file.getDocument();
        assert (document != null);
        XmlTag rootTag = document.getRootTag();
        XmlElementFactory elementFactory = XmlElementFactory.getInstance((Project)project);
        assert (rootTag != null);
        XmlTag childTag = rootTag.createChildTag("directive.taglib", "http://java.sun.com/JSP/Page", null, false);
        PsiElement element = childTag.add((PsiElement)elementFactory.createXmlAttribute("prefix", prefix));
        childTag.addAfter((PsiElement)elementFactory.createXmlAttribute(URI_ATTR_NAME, namespace), element);
        XmlTag[] directives = ((JspFile)file).getDirectiveTags(JspDirectiveKind.TAGLIB, false);
        element = directives == null || directives.length == 0 ? rootTag.addBefore((PsiElement)childTag, rootTag.getFirstChild()) : rootTag.addAfter((PsiElement)childTag, (PsiElement)directives[directives.length - 1]);
        CodeStyleManager.getInstance((Project)project).reformat(element);
        if (editor != null && namespace.isEmpty() && (xmlAttribute = ((XmlTag)element).getAttribute(URI_ATTR_NAME)) != null) {
            XmlAttributeValue value = xmlAttribute.getValueElement();
            assert (value != null);
            int startOffset = value.getTextOffset();
            editor.getCaretModel().moveToOffset(startOffset);
        }
    }

    static boolean isJspx(XmlFile file) {
        return file.getLanguage() == StdLanguages.JSPX;
    }

    public boolean isAvailable(PsiFile file) {
        return file.getViewProvider() instanceof JspxFileViewProvider;
    }

    public void insertNamespaceDeclaration(@NotNull XmlFile file, final @Nullable Editor editor, final @NotNull Set<String> possibleNamespaces, final @Nullable String nsPrefix, final @Nullable XmlNamespaceHelper.Runner<String, IncorrectOperationException> runAfter) throws IncorrectOperationException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "insertNamespaceDeclaration"));
        }
        if (possibleNamespaces == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleNamespaces", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "insertNamespaceDeclaration"));
        }
        final JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file);
        assert (jspFile != null);
        if (JspXmlNamespaceHelper.isJspx((XmlFile)jspFile)) {
            DEFAULT_EXTENSION.insertNamespaceDeclaration((XmlFile)jspFile, editor, possibleNamespaces, nsPrefix, runAfter);
            return;
        }
        if (nsPrefix == null) {
            return;
        }
        if (StringUtil.isEmpty((String)nsPrefix) && possibleNamespaces.size() == 1) {
            JspXmlNamespaceHelper.insertTaglibDeclaration((XmlFile)jspFile, editor, possibleNamespaces.iterator().next(), nsPrefix);
            if (runAfter != null) {
                runAfter.run((Object)nsPrefix);
            }
            return;
        }
        final Project project = jspFile.getProject();
        XmlTag[] directives = jspFile.getDirectiveTags(JspDirectiveKind.TAGLIB, false);
        int offset = 0;
        if (directives.length != 0) {
            offset = directives[directives.length - 1].getTextRange().getEndOffset();
        }
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        Template template = templateManager.createTemplate("", "");
        template.setToIndent(true);
        template.addTextSegment("<%@ taglib prefix=\"");
        template.addTextSegment(nsPrefix);
        template.addTextSegment("\" uri=\"");
        if (possibleNamespaces.size() == 1) {
            String namespace = possibleNamespaces.iterator().next();
            if (namespace.isEmpty()) {
                MacroCallNode macro = new MacroCallNode(MacroFactory.createMacro((String)"complete"));
                template.addVariable("namespace", (Expression)macro, (Expression)macro, true);
            } else {
                template.addTextSegment(namespace);
            }
        } else {
            EmptyExpression expression = new EmptyExpression(){

                public LookupElement[] calculateLookupItems(ExpressionContext context) {
                    LookupElement[] lookupItems = new LookupElement[possibleNamespaces.size()];
                    int i = 0;
                    for (String namespace : possibleNamespaces) {
                        lookupItems[i++] = LookupElementBuilder.create((String)namespace);
                    }
                    return lookupItems;
                }
            };
            template.addVariable(URI_ATTR_NAME, (Expression)expression, (Expression)expression, true);
        }
        template.addTextSegment("\"%>" + (offset == 0 ? "\n" : ""));
        if (editor == null) {
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)file);
            String text = template.getTemplateText();
            assert (document != null);
            document.insertString(offset, (CharSequence)text);
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            CodeStyleManager.getInstance((Project)project).reformatText((PsiFile)file, offset, offset + text.length() + 2);
            if (runAfter != null) {
                runAfter.run((Object)nsPrefix);
            }
            return;
        }
        editor.getCaretModel().moveToOffset(offset);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        templateManager.startTemplate(editor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

            public void templateFinished(Template template, boolean brokenOff) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                new WriteCommandAction.Simple(project, new PsiFile[0]){

                    protected void run() throws Throwable {
                        XmlTag[] directives = jspFile.getDirectiveTags(JspDirectiveKind.TAGLIB, false);
                        String prefix = nsPrefix;
                        if (directives.length > 0) {
                            XmlTag lastDirective = directives[directives.length - 1];
                            if (StringUtil.isEmpty((String)nsPrefix)) {
                                prefix = lastDirective.getAttributeValue("prefix");
                            }
                            int start = lastDirective.getTextOffset();
                            int end = lastDirective.getTextRange().getEndOffset();
                            int textLength = editor.getDocument().getTextLength();
                            if (textLength > end + 1) {
                                ++end;
                            }
                            CodeStyleManager.getInstance((Project)project).reformatText((PsiFile)jspFile, start, end + 1);
                        }
                        if (runAfter != null) {
                            try {
                                runAfter.run((Object)prefix);
                            }
                            catch (IncorrectOperationException e) {
                                LOG.error((Throwable)e);
                            }
                        }
                    }
                }.execute().logException(LOG);
            }
        });
    }

    public String getNamespacePrefix(PsiElement element) {
        String prefix = super.getNamespacePrefix(element);
        if (prefix != null) {
            return prefix;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof ELFunctionCallExpression) {
            ELVariable namespace = ((ELFunctionCallExpression)parent).getNamespace();
            return namespace.getText();
        }
        return null;
    }

    public boolean qualifyWithPrefix(String namespacePrefix, PsiElement element, Document document) throws IncorrectOperationException {
        if (!super.qualifyWithPrefix(namespacePrefix, element, document)) {
            PsiElement parent = element.getParent();
            if (parent instanceof ELVariable) {
                return true;
            }
            int offset = element.getTextOffset();
            document.insertString(offset, (CharSequence)(namespacePrefix + ":"));
            return true;
        }
        return false;
    }

    @NotNull
    public Set<String> guessUnboundNamespaces(@NotNull PsiElement element, XmlFile file) {
        HashSet<String> result;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "guessUnboundNamespaces"));
        }
        if (!element.isValid()) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "guessUnboundNamespaces"));
            }
            return set;
        }
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)element);
        if (jspFile == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "guessUnboundNamespaces"));
            }
            return set;
        }
        JspManager jspManager = JspManager.getInstance((Project)element.getProject());
        if (element instanceof ELVariable) {
            PsiElement parent = element.getParent();
            String name = parent instanceof ELFunctionCallExpression ? ((ELFunctionCallExpression)parent).getFunctionName() : element.getText();
            Set set = name == null ? Collections.emptySet() : jspManager.getNamespacesByFunctionName(name, jspFile, false);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "guessUnboundNamespaces"));
            }
            return set;
        }
        XmlTag xmlTag = (XmlTag)(element instanceof XmlTag ? element : element.getParent());
        String text = xmlTag.getName().trim();
        int pos = text.indexOf(58);
        if (pos == -1) {
            result = jspManager.getNamespacesByTagName(text, jspFile, false);
        } else if (pos == text.length() - 1) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)xmlTag);
            if (module == null) {
                Set<String> set = Collections.emptySet();
                if (set == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "guessUnboundNamespaces"));
                }
                return set;
            }
            String prefix = text.substring(0, text.length() - 1);
            Collection files = jspManager.getPossibleTldFiles(module);
            result = new HashSet<String>();
            for (XmlFile psiFile : files) {
                String uri;
                TldDescriptor descriptor;
                String defaultPrefix;
                PsiMetaData metaData;
                XmlDocument document = psiFile.getDocument();
                if (document == null || !((metaData = document.getMetaData()) instanceof TldDescriptor) || (defaultPrefix = (descriptor = (TldDescriptor)metaData).getDefaultPrefix()) == null || !defaultPrefix.equals(prefix) || StringUtil.isEmpty((String)(uri = descriptor.getUri()))) continue;
                result.add(uri);
            }
        } else {
            String tagName = text.substring(pos + 1);
            result = jspManager.getNamespacesByTagName(tagName, jspFile, false);
        }
        if (JspXmlNamespaceHelper.isJspx((XmlFile)jspFile)) {
            HashSet<String> strings = new HashSet<String>(DEFAULT_EXTENSION.guessUnboundNamespaces((PsiElement)xmlTag, (XmlFile)jspFile));
            strings.addAll(result);
            HashSet<String> hashSet = strings;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "guessUnboundNamespaces"));
            }
            return hashSet;
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "guessUnboundNamespaces"));
        }
        return hashSet;
    }

    public String getNamespaceAlias(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "getNamespaceAlias"));
        }
        return JspXmlNamespaceHelper.isJspx(file) ? super.getNamespaceAlias(file) : JspBundle.message("namespace.alias", new Object[0]);
    }

    @NotNull
    public Set<String> getNamespacesByTagName(@NotNull String tagName, @NotNull XmlFile context) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "getNamespacesByTagName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "getNamespacesByTagName"));
        }
        Set set = JspManager.getInstance((Project)context.getProject()).getNamespacesByTagName(tagName, (JspFile)context, false);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/JspXmlNamespaceHelper", "getNamespacesByTagName"));
        }
        return set;
    }
}

