/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.jsp.jspJava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportList;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatement;
import com.intellij.psi.impl.source.jsp.jspJava.JspxImportStatementImpl;
import com.intellij.psi.impl.source.jsp.jspJava.JspxStaticImportStatement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

class JspxImportListAttribute {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.jsp.jspJava.JspxImportListAttribute");
    private final XmlAttribute myAttribute;
    private final JspxImportList myImportList;
    private final AtomicReference<List<JspxImportStatementImpl>> myImports;
    private final AtomicReference<List<JspxStaticImportStatement>> myStaticImports;
    private volatile boolean[] myIsStaticImport;
    private volatile TextRange[] myImportStatementRanges;

    public JspxImportListAttribute(@NotNull XmlAttribute attribute, @NotNull JspxImportList importList) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListAttribute", "<init>"));
        }
        if (importList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importList", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListAttribute", "<init>"));
        }
        this.myImports = new AtomicReference();
        this.myStaticImports = new AtomicReference();
        this.myAttribute = attribute;
        this.myImportList = importList;
    }

    @NotNull
    JspxImportStatementImpl[] getImportStatements() {
        this.ensureRangesAreBuilt();
        List<JspxImportStatementImpl> imports = this.myImports.get();
        if (imports == null) {
            boolean[] staticImport = this.myIsStaticImport;
            TextRange[] importStatementRanges = this.myImportStatementRanges;
            imports = new ArrayList<JspxImportStatementImpl>(importStatementRanges.length);
            for (int i = 0; i < importStatementRanges.length; ++i) {
                if (staticImport[i]) continue;
                imports.add(new JspxImportStatementImpl(this.myImportList, this, importStatementRanges[i]));
            }
            if (!this.myImports.compareAndSet(null, imports)) {
                imports = this.myImports.get();
            }
        }
        JspxImportStatementImpl[] jspxImportStatementImplArray = imports.toArray(new JspxImportStatementImpl[imports.size()]);
        if (jspxImportStatementImplArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListAttribute", "getImportStatements"));
        }
        return jspxImportStatementImplArray;
    }

    @NotNull
    JspxStaticImportStatement[] getStaticImportStatements() {
        this.ensureRangesAreBuilt();
        List<JspxStaticImportStatement> imports = this.myStaticImports.get();
        if (imports == null) {
            TextRange[] importStatementRanges = this.myImportStatementRanges;
            boolean[] staticImport = this.myIsStaticImport;
            imports = new ArrayList<JspxStaticImportStatement>(importStatementRanges.length);
            for (int i = 0; i < importStatementRanges.length; ++i) {
                if (!staticImport[i]) continue;
                imports.add(new JspxStaticImportStatement(this.myImportList, this, importStatementRanges[i]));
            }
            if (!this.myStaticImports.compareAndSet(null, imports)) {
                imports = this.myStaticImports.get();
            }
        }
        JspxStaticImportStatement[] jspxStaticImportStatementArray = imports.toArray(new JspxStaticImportStatement[imports.size()]);
        if (jspxStaticImportStatementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/jsp/jspJava/JspxImportListAttribute", "getStaticImportStatements"));
        }
        return jspxStaticImportStatementArray;
    }

    private void ensureRangesAreBuilt() {
        TextRange[] importStatementRanges = this.myImportStatementRanges;
        boolean[] staticImport = this.myIsStaticImport;
        if (importStatementRanges != null && staticImport != null) {
            return;
        }
        String importList = this.getAttribute().getValue();
        if (importList == null) {
            this.myImportStatementRanges = new TextRange[0];
            this.myIsStaticImport = ArrayUtil.EMPTY_BOOLEAN_ARRAY;
            return;
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        ArrayList<Boolean> isStatic = new ArrayList<Boolean>();
        int start = 0;
        while (true) {
            TextRange textRange;
            int delim;
            if ((delim = importList.indexOf(44, start)) == -1) {
                delim = importList.length();
            }
            if (delim <= start) break;
            String importString = importList.substring(start, delim);
            String importClass = importString.trim();
            boolean isStaticImport = false;
            int trimOffset = importList.indexOf(importClass, start);
            String staticPrefix = "static ";
            if (importClass.startsWith(staticPrefix)) {
                isStaticImport = true;
            }
            if (!(textRange = new TextRange(trimOffset, trimOffset + importClass.length())).isEmpty()) {
                ranges.add(textRange);
                isStatic.add(isStaticImport);
            }
            start = delim + 1;
        }
        boolean[] booleans = new boolean[isStatic.size()];
        for (int i = 0; i < isStatic.size(); ++i) {
            Boolean isS = (Boolean)isStatic.get(i);
            booleans[i] = isS;
        }
        this.myImportStatementRanges = ranges.toArray(new TextRange[ranges.size()]);
        this.myIsStaticImport = booleans;
    }

    void delete(int index) {
        this.getImportStatements();
        TextRange[] importStatementRanges = this.myImportStatementRanges;
        if (importStatementRanges.length > 1) {
            TextRange textRange = index > 0 ? new TextRange(importStatementRanges[index - 1].getEndOffset(), importStatementRanges[index].getEndOffset()) : new TextRange(0, importStatementRanges[index + 1].getStartOffset());
            this.myImports.get().remove(index);
            this.replacePartOfAttribute(textRange, "");
        } else {
            try {
                XmlTag parent = this.getAttribute().getParent();
                if (parent.getValue().getTextRange().getLength() == 0 && parent.getAttributes().length == 1) {
                    parent.delete();
                } else {
                    this.myAttribute.delete();
                }
                this.myImportStatementRanges = null;
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    void replace(int index, String fqn) {
        this.getImportStatements();
        TextRange importStatementRange = this.myImportStatementRanges[index];
        this.replacePartOfAttribute(importStatementRange, fqn);
    }

    private void replacePartOfAttribute(TextRange importStatementRange, String newValue) {
        try {
            String value = this.getAttribute().getValue();
            assert (value != null);
            this.getAttribute().setValue(value.substring(0, importStatementRange.getStartOffset()) + newValue + value.substring(importStatementRange.getEndOffset()));
            this.myImportStatementRanges = null;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public XmlAttribute getAttribute() {
        return this.myAttribute;
    }

    int getIndex(JspxImportStatement statement) {
        List<JspxImportStatementImpl> imports = (statement instanceof JspxStaticImportStatement ? this.myStaticImports : this.myImports).get();
        for (int i = 0; i < imports.size(); ++i) {
            JspxImportStatement importStatement = imports.get(i);
            if (importStatement != statement) continue;
            return i;
        }
        return -1;
    }
}

