/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.integration.injection.el;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.jsp.el.ELExpression;
import com.intellij.psi.jsp.el.ELLiteralExpression;
import com.intellij.psi.jsp.el.ELSliceExpression;
import com.intellij.psi.jsp.el.ELVariable;
import com.intellij.psi.jsp.el.ElLiteralCustomReferenceProvider;
import com.intellij.spring.integration.injection.el.HeadersVariable;
import com.intellij.spring.integration.model.xml.fake.SpringIntegrationHeader;
import com.intellij.spring.integration.model.xml.fake.SpringIntegrationHeadersFactory;
import com.intellij.spring.integration.util.SpringIntegrationUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringIntegrationHeaderELLiteralCustomReferenceProvider
implements ElLiteralCustomReferenceProvider {
    public boolean accept(@NotNull ELLiteralExpression expression) {
        ELExpression from;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/integration/injection/el/SpringIntegrationHeaderELLiteralCustomReferenceProvider", "accept"));
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof ELSliceExpression && (from = ((ELSliceExpression)parent).getFrom()) instanceof ELVariable) {
            PsiElement element;
            ELVariable elVariable = (ELVariable)from;
            if (!"headers".equals(elVariable.getName())) {
                return false;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)expression);
            if (!SpringIntegrationUtil.isSpringIntegrationUsed(module)) {
                return false;
            }
            PsiReference[] references = elVariable.getReferences();
            if (references.length > 0 && (element = references[0].resolve()) instanceof HeadersVariable) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull ELLiteralExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/integration/injection/el/SpringIntegrationHeaderELLiteralCustomReferenceProvider", "createReferences"));
        }
        String text = expression.getText();
        if (text.length() < 2) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/injection/el/SpringIntegrationHeaderELLiteralCustomReferenceProvider", "createReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String textValue = text.substring(1, text.length() - 1);
        PsiReference[] psiReferenceArray = new PsiReference[]{new HeaderNameReference((PsiElement)expression, TextRange.from((int)1, (int)textValue.length()))};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/injection/el/SpringIntegrationHeaderELLiteralCustomReferenceProvider", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static class HeaderNameReference
    extends PsiReferenceBase.Poly<PsiElement> {
        private HeaderNameReference(PsiElement element, TextRange range) {
            super(element, range, false);
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            Set<SpringIntegrationHeader> headers = this.getHeaders();
            String headerName = this.getValue();
            SmartList matchingHeaders = new SmartList();
            for (SpringIntegrationHeader header : headers) {
                if (!header.getName().equals(headerName)) continue;
                matchingHeaders.add(header);
            }
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)matchingHeaders);
            if (resolveResultArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/injection/el/SpringIntegrationHeaderELLiteralCustomReferenceProvider$HeaderNameReference", "multiResolve"));
            }
            return resolveResultArray;
        }

        @NotNull
        public Object[] getVariants() {
            Object[] objectArray = ArrayUtil.toObjectArray(this.getHeaders());
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/integration/injection/el/SpringIntegrationHeaderELLiteralCustomReferenceProvider$HeaderNameReference", "getVariants"));
            }
            return objectArray;
        }

        private Set<SpringIntegrationHeader> getHeaders() {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.getElement());
            if (module == null) {
                return Collections.emptySet();
            }
            return SpringIntegrationHeadersFactory.getInstance(module).getHeaders();
        }
    }
}

