/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.editor;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.actions.DiagramCreateNewElementAction;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NonEmptyInputValidator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.webflow.diagram.WebflowDiagramDataModel;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowDomElementWrapper;
import com.intellij.spring.webflow.diagram.beans.wrappers.WebflowElementWrapper;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.xml.WebflowDomElement;
import com.intellij.util.xml.DomElement;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;

public abstract class CreateWebflowElementActionBase<T extends WebflowDomElement>
extends DiagramCreateNewElementAction<WebflowElementWrapper, String> {
    private final Class<T> myElementClazz;

    protected CreateWebflowElementActionBase(Class<T> elementClazz) {
        super(TypePresentationService.getDefaultTypeName(elementClazz), "Create New " + TypePresentationService.getDefaultTypeName(elementClazz), TypePresentationService.getService().getTypeIcon(elementClazz));
        this.myElementClazz = elementClazz;
    }

    public WebflowElementWrapper createElement(DiagramDataModel<WebflowElementWrapper> model, String s, AnActionEvent event) {
        WebflowDiagramDataModel myModel = (WebflowDiagramDataModel)model;
        List<WebflowModel> flowModels = myModel.getFlowModels();
        if (flowModels.size() != 1) {
            Messages.showErrorDialog((Component)((Component)event.getData(PlatformDataKeys.CONTEXT_COMPONENT)), (String)"Multiple Flows not supported currently");
            return null;
        }
        WebflowModel webflowModel = flowModels.get(0);
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)webflowModel.getFlow().getXmlElement())) {
            return null;
        }
        T domElement = this.create(webflowModel, s);
        return new WebflowDomElementWrapper((DomElement)domElement);
    }

    protected abstract T create(WebflowModel var1, String var2);

    public String prepare(AnActionEvent e) {
        return Messages.showInputDialog((Project)((Project)e.getData(CommonDataKeys.PROJECT)), (String)"Enter name", (String)("Create New " + TypePresentationService.getDefaultTypeName(this.myElementClazz)), (Icon)Messages.getQuestionIcon(), (String)"", (InputValidator)new NonEmptyInputValidator());
    }

    public String getActionName() {
        return this.getTemplatePresentation().getText();
    }

    public PsiFile[] getAffectedFiles(AnActionEvent e) {
        WebflowDiagramDataModel model = (WebflowDiagramDataModel)DiagramAction.getDataModel((AnActionEvent)e);
        assert (model != null);
        return model.getAffectedFiles();
    }

    public boolean isEnabled(AnActionEvent e, DiagramBuilder builder) {
        if (builder.isPopupMode()) {
            return false;
        }
        return ((WebflowDiagramDataModel)builder.getDataModel()).getFlowModels().size() == 1;
    }
}

