/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.inspections;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.util.InspectionValidator;
import com.intellij.openapi.compiler.util.InspectionValidatorUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.inspections.WebflowInspectionToolProvider;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.resources.WebflowBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class WebflowModelInspectionValidator
extends InspectionValidator {
    public WebflowModelInspectionValidator() {
        super(WebflowBundle.message("compiler.validator.flow.name", new Object[0]), WebflowBundle.message("compiler.validator.flow.progress", new Object[0]));
    }

    public boolean isAvailableOnScope(@NotNull CompileScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/spring/webflow/inspections/WebflowModelInspectionValidator", "isAvailableOnScope"));
        }
        return true;
    }

    public Collection<VirtualFile> getFilesToProcess(Project project, CompileContext context) {
        ArrayList<VirtualFile> toProcess = new ArrayList<VirtualFile>();
        for (Module module : context.getCompileScope().getAffectedModules()) {
            List<WebflowModel> models = WebflowDomModelManager.getInstance(project).getAllModels(module);
            for (WebflowModel model : models) {
                XmlFile flowXml = model.getFlowFile();
                toProcess.add(flowXml.getVirtualFile());
            }
        }
        InspectionValidatorUtil.expandCompileScopeIfNeeded(toProcess, (CompileContext)context);
        return toProcess;
    }

    @NotNull
    public Class<? extends LocalInspectionTool>[] getInspectionToolClasses(CompileContext context) {
        Class[] classArray = new WebflowInspectionToolProvider().getInspectionClasses();
        if (classArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/inspections/WebflowModelInspectionValidator", "getInspectionToolClasses"));
        }
        return classArray;
    }
}

