/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.converters.WebflowLookupUtil;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IdentifiedStateConverter
extends ResolvingConverter<Identified> {
    public Identified fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        if (WebflowUtil.isDynamicExpression(s)) {
            return null;
        }
        WebflowModel webflowModel = IdentifiedStateConverter.getWebflowModel(context);
        if (webflowModel == null) {
            return null;
        }
        Flow flow = webflowModel.getFlow();
        List<Identified> identifiedList = IdentifiedStateConverter.getAllIdentified(flow);
        for (Identified identified : identifiedList) {
            if (!s.equals(identified.getId().getStringValue())) continue;
            return identified;
        }
        return null;
    }

    public LookupElement createLookupElement(Identified identified) {
        return WebflowLookupUtil.forIdentified(identified);
    }

    @Nullable
    private static WebflowModel getWebflowModel(ConvertContext context) {
        XmlFile xmlFile = context.getFile();
        return WebflowDomModelManager.getInstance(xmlFile.getProject()).getWebflowModel(xmlFile);
    }

    public String toString(@Nullable Identified identified, ConvertContext context) {
        if (identified == null) {
            return null;
        }
        return identified.getId().getStringValue();
    }

    @NotNull
    public Collection<Identified> getVariants(ConvertContext context) {
        WebflowModel model = IdentifiedStateConverter.getWebflowModel(context);
        List<Identified> list = model == null ? Collections.emptyList() : IdentifiedStateConverter.getAllIdentified(model.getFlow());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/IdentifiedStateConverter", "getVariants"));
        }
        return list;
    }

    @NotNull
    private static List<Identified> getAllIdentified(@Nullable Flow flow) {
        if (flow == null) {
            List<Identified> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/IdentifiedStateConverter", "getAllIdentified"));
            }
            return list;
        }
        ArrayList<Identified> identifiedList = new ArrayList<Identified>();
        IdentifiedStateConverter.addIdentified(flow, identifiedList);
        for (Flow parentFlow : flow.getAllRelatedFlows()) {
            IdentifiedStateConverter.addIdentified(parentFlow, identifiedList);
        }
        ArrayList<Identified> arrayList = identifiedList;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/model/converters/IdentifiedStateConverter", "getAllIdentified"));
        }
        return arrayList;
    }

    private static void addIdentified(Flow flow, List<Identified> identifiedList) {
        identifiedList.addAll(flow.getActionStates());
        identifiedList.addAll(flow.getDecisionStates());
        identifiedList.addAll(flow.getEndStates());
        identifiedList.addAll(flow.getSubflowStates());
        identifiedList.addAll(flow.getViewStates());
    }
}

