/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.util;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.libraries.JarVersionDetectionUtil;
import com.intellij.spring.webflow.model.WebflowVersion;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public class WebflowVersionDetector {
    private WebflowVersionDetector() {
    }

    @NotNull
    public static WebflowVersion detect(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/webflow/util/WebflowVersionDetector", "detect"));
        }
        String versionString = JarVersionDetectionUtil.detectJarVersion((String)"org.springframework.webflow.execution.Action", (Module)module);
        if (versionString == null) {
            WebflowVersion webflowVersion = WebflowVersion.Webflow_2_3_1;
            if (webflowVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/util/WebflowVersionDetector", "detect"));
            }
            return webflowVersion;
        }
        for (WebflowVersion version : (WebflowVersion[])ArrayUtil.reverseArray((Object[])WebflowVersion.values())) {
            if (!versionString.startsWith(version.getVersion())) continue;
            WebflowVersion webflowVersion = version;
            if (webflowVersion == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/util/WebflowVersionDetector", "detect"));
            }
            return webflowVersion;
        }
        WebflowVersion webflowVersion = WebflowVersion.Webflow_2_3_1;
        if (webflowVersion == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/util/WebflowVersionDetector", "detect"));
        }
        return webflowVersion;
    }
}

