/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.GetOperation;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.LockLevel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.ResultWithFailures;
import org.jetbrains.tfsIntegration.core.tfs.TfsFileUtil;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkstationHelper;
import org.jetbrains.tfsIntegration.core.tfs.locks.LockItemModel;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.LockItemsDialog;

public class LockAction
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)e);
        final ArrayList<LockItemModel> items = new ArrayList<LockItemModel>();
        final ArrayList exceptions = new ArrayList();
        final Ref mappingFound = new Ref((Object)false);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                    WorkstationHelper.processByWorkspaces(TfsFileUtil.getFilePaths(files), false, project, new WorkstationHelper.VoidProcessDelegate(){

                        @Override
                        public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                            mappingFound.set((Object)true);
                            Map<FilePath, ExtendedItem> itemsMap = workspace.getExtendedItems2(paths, project, TFSBundle.message("loading.items", new Object[0]));
                            for (ExtendedItem item : itemsMap.values()) {
                                if (item == null) continue;
                                items.add(new LockItemModel(item, workspace));
                            }
                        }
                    });
                }
                catch (TfsException e) {
                    exceptions.add(new VcsException((Throwable)e));
                }
            }
        }, "Reading existing locks...", false, project);
        if (!exceptions.isEmpty()) {
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, "TFS");
            return;
        }
        if (!((Boolean)mappingFound.get()).booleanValue()) {
            Messages.showInfoMessage((Project)project, (String)"Team Foundation Server mappings not found.", (String)e.getPresentation().getText());
            return;
        }
        if (items.isEmpty()) {
            Messages.showInfoMessage((Project)project, (String)"Server item not found.", (String)e.getPresentation().getText());
            return;
        }
        LockAction.performInitialSelection(items);
        final LockItemsDialog d = new LockItemsDialog(project, items);
        d.show();
        int exitCode = d.getExitCode();
        if (exitCode != 2 && exitCode != 3) {
            return;
        }
        final List<LockItemModel> selectedItems = d.getSelectedItems();
        String title = d.getLockLevel() == LockLevel.None ? "Unlocking..." : "Locking...";
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressManager.getInstance().getProgressIndicator().setIndeterminate(true);
                exceptions.addAll(LockAction.lockOrUnlockItems(selectedItems, d.getLockLevel(), project));
            }
        }, title, false, project);
        if (exceptions.isEmpty()) {
            String message = MessageFormat.format("{0} {1} {2}", selectedItems.size(), selectedItems.size() == 1 ? "item" : "items", exitCode == 2 ? "locked" : "unlocked");
            TfsUtil.showBalloon(project, MessageType.INFO, message);
        } else {
            AbstractVcsHelper.getInstance((Project)project).showErrors(exceptions, "TFS");
        }
    }

    private static void performInitialSelection(List<LockItemModel> items) {
        boolean unlockableExists = false;
        for (LockItemModel item : items) {
            if (!item.canBeUnlocked()) continue;
            unlockableExists = true;
            item.setSelectionStatus(Boolean.TRUE);
        }
        if (!unlockableExists) {
            for (LockItemModel item : items) {
                if (!item.canBeLocked()) continue;
                item.setSelectionStatus(Boolean.TRUE);
            }
        }
    }

    private static List<VcsException> lockOrUnlockItems(List<LockItemModel> items, LockLevel lockLevel, Project project) {
        HashMap<WorkspaceInfo, ArrayList<ExtendedItem>> itemsByWorkspace = new HashMap<WorkspaceInfo, ArrayList<ExtendedItem>>();
        for (LockItemModel item : items) {
            ArrayList<ExtendedItem> itemsForWorkspace = (ArrayList<ExtendedItem>)itemsByWorkspace.get(item.getWorkspace());
            if (itemsForWorkspace == null) {
                itemsForWorkspace = new ArrayList<ExtendedItem>();
                itemsByWorkspace.put(item.getWorkspace(), itemsForWorkspace);
            }
            itemsForWorkspace.add(item.getExtendedItem());
        }
        ArrayList<VcsException> exceptions = new ArrayList<VcsException>();
        for (Map.Entry entry : itemsByWorkspace.entrySet()) {
            try {
                WorkspaceInfo workspace = (WorkspaceInfo)entry.getKey();
                ResultWithFailures<GetOperation> resultWithFailures = workspace.getServer().getVCS().lockOrUnlockItems(workspace.getName(), workspace.getOwnerName(), lockLevel, (Collection)entry.getValue(), project, TFSBundle.message("applying.locks", new Object[0]));
                exceptions.addAll(TfsUtil.getVcsExceptions(resultWithFailures.getFailures()));
            }
            catch (TfsException e) {
                exceptions.add(new VcsException((Throwable)e));
            }
        }
        return exceptions;
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile[] files = VcsUtil.getVirtualFiles((AnActionEvent)e);
        e.getPresentation().setEnabled(LockAction.isEnabled(project, files));
    }

    private static boolean isEnabled(Project project, VirtualFile[] files) {
        if (files.length == 0) {
            return false;
        }
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)project);
        for (VirtualFile file : files) {
            FileStatus fileStatus = fileStatusManager.getStatus(file);
            if (fileStatus == FileStatus.NOT_CHANGED || fileStatus == FileStatus.MODIFIED || fileStatus == FileStatus.HIJACKED) continue;
            return false;
        }
        return true;
    }
}

