/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.checkin;

import java.text.MessageFormat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.checkin.CheckinPoliciesManager;
import org.jetbrains.tfsIntegration.checkin.PolicyFailure;
import org.jetbrains.tfsIntegration.checkin.PolicyType;

public class NotInstalledPolicyFailure
extends PolicyFailure {
    private final PolicyType myPolicyType;

    public NotInstalledPolicyFailure(@NotNull PolicyType policyType, boolean reportId) {
        if (policyType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "policyType", "org/jetbrains/tfsIntegration/checkin/NotInstalledPolicyFailure", "<init>"));
        }
        super(CheckinPoliciesManager.DUMMY_POLICY, NotInstalledPolicyFailure.getMessage(policyType), NotInstalledPolicyFailure.getTooltip(policyType, reportId));
        this.myPolicyType = policyType;
    }

    private static String getMessage(PolicyType type) {
        return MessageFormat.format("Checkin policy ''{0}'' is not installed", type.getName());
    }

    private static String getTooltip(PolicyType type, boolean reportId) {
        if (reportId) {
            return MessageFormat.format("Policy id: {0}\n{1}", type.getId(), type.getInstallationInstructions());
        }
        return type.getInstallationInstructions();
    }

    @Override
    public String getPolicyName() {
        return this.myPolicyType.getName();
    }
}

