/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.ChangeListColumn;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.RepositoryLocation;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.committed.DecoratorManager;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedListsZipper;
import com.intellij.openapi.vcs.changes.committed.VcsCommittedViewAuxiliary;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.ChangesBrowserSettingsEditor;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.AsynchConsumer;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Changeset;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ExtendedItem;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemSpec;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.ItemType;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.RecursionType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.TFSChangeList;
import org.jetbrains.tfsIntegration.core.TFSRepositoryLocation;
import org.jetbrains.tfsIntegration.core.TFSVcs;
import org.jetbrains.tfsIntegration.core.tfs.ItemPath;
import org.jetbrains.tfsIntegration.core.tfs.TfsRevisionNumber;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlServer;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkstationHelper;
import org.jetbrains.tfsIntegration.core.tfs.version.ChangesetVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.DateVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.LatestVersionSpec;
import org.jetbrains.tfsIntegration.core.tfs.version.VersionSpecBase;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.ui.TFSVersionFilterComponent;

public class TFSCommittedChangesProvider
implements CachingCommittedChangesProvider<TFSChangeList, ChangeBrowserSettings> {
    private final Project myProject;
    private final TFSVcs myVcs;

    public TFSCommittedChangesProvider(TFSVcs vcs, Project project) {
        this.myProject = project;
        this.myVcs = vcs;
    }

    public TFSCommittedChangesProvider(Project project) {
        this.myProject = project;
        this.myVcs = TFSVcs.getInstance(this.myProject);
    }

    @NotNull
    public ChangeBrowserSettings createDefaultSettings() {
        ChangeBrowserSettings changeBrowserSettings = new ChangeBrowserSettings();
        if (changeBrowserSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TFSCommittedChangesProvider", "createDefaultSettings"));
        }
        return changeBrowserSettings;
    }

    public ChangesBrowserSettingsEditor<ChangeBrowserSettings> createFilterUI(boolean showDateFilter) {
        return new TFSVersionFilterComponent(showDateFilter);
    }

    @Nullable
    public VcsCommittedListsZipper getZipper() {
        return null;
    }

    @Nullable
    public RepositoryLocation getLocationFor(FilePath root, String repositoryPath) {
        return this.getLocationFor(root);
    }

    public RepositoryLocation getLocationFor(FilePath root) {
        final HashMap<WorkspaceInfo, List<FilePath>> pathsByWorkspaces = new HashMap<WorkspaceInfo, List<FilePath>>();
        try {
            WorkstationHelper.processByWorkspaces(Collections.singletonList(root), true, this.myProject, new WorkstationHelper.VoidProcessDelegate(){

                @Override
                public void executeRequest(WorkspaceInfo workspace, List<ItemPath> paths) throws TfsException {
                    pathsByWorkspaces.put(workspace, TfsUtil.getLocalPaths(paths));
                }
            });
            if (!pathsByWorkspaces.isEmpty()) {
                return new TFSRepositoryLocation(pathsByWorkspaces);
            }
        }
        catch (TfsException e) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showError(new VcsException(e.getMessage(), (Throwable)e), "TFS");
        }
        catch (ProcessCanceledException e) {
            AbstractVcsHelper.getInstance((Project)this.myProject).showError(new VcsException(TFSBundle.message("operation.canceled", new Object[0])), "TFS");
        }
        return null;
    }

    public Pair<TFSChangeList, FilePath> getOneList(VirtualFile file, VcsRevisionNumber number) throws VcsException {
        ChangeBrowserSettings settings = this.createDefaultSettings();
        settings.USE_CHANGE_AFTER_FILTER = true;
        settings.USE_CHANGE_BEFORE_FILTER = true;
        settings.CHANGE_BEFORE = settings.CHANGE_AFTER = String.valueOf(((TfsRevisionNumber)number).getValue());
        FilePath filePath = VcsContextFactory.SERVICE.getInstance().createFilePathOn(file);
        List<TFSChangeList> list = this.getCommittedChanges(settings, this.getLocationFor(filePath), 1);
        if (list.size() == 1) {
            return Pair.create((Object)list.get(0), (Object)filePath);
        }
        return null;
    }

    public RepositoryLocation getForNonLocal(VirtualFile file) {
        return null;
    }

    public boolean supportsIncomingChanges() {
        return true;
    }

    public void loadCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount, AsynchConsumer<CommittedChangeList> consumer) throws VcsException {
        VersionSpecBase versionFrom = new ChangesetVersionSpec(1);
        if (settings.getChangeAfterFilter() != null) {
            versionFrom = new ChangesetVersionSpec((int)settings.getChangeAfterFilter().longValue());
        }
        if (settings.getDateAfterFilter() != null) {
            versionFrom = new DateVersionSpec(settings.getDateAfterFilter());
        }
        VersionSpecBase versionTo = LatestVersionSpec.INSTANCE;
        if (settings.getChangeBeforeFilter() != null) {
            versionTo = new ChangesetVersionSpec((int)settings.getChangeBeforeFilter().longValue());
        }
        if (settings.getDateBeforeFilter() != null) {
            versionTo = new DateVersionSpec(settings.getDateBeforeFilter());
        }
        TFSRepositoryLocation tfsRepositoryLocation = (TFSRepositoryLocation)location;
        try {
            for (Map.Entry<WorkspaceInfo, List<FilePath>> entry : tfsRepositoryLocation.getPathsByWorkspaces().entrySet()) {
                WorkspaceInfo workspace = entry.getKey();
                Map<FilePath, ExtendedItem> extendedItems = workspace.getExtendedItems(entry.getValue(), this.myProject, TFSBundle.message("loading.items", new Object[0]));
                for (Map.Entry<FilePath, ExtendedItem> localPath2ExtendedItem : extendedItems.entrySet()) {
                    ChangesetVersionSpec changesetVersionTo;
                    VersionSpecBase changesetVersionFrom;
                    ExtendedItem extendedItem = localPath2ExtendedItem.getValue();
                    if (extendedItem == null) continue;
                    int itemLatestVersion = this.getLatestChangesetId(workspace, settings.getUserFilter(), extendedItem);
                    if (versionFrom instanceof ChangesetVersionSpec && ((ChangesetVersionSpec)(changesetVersionFrom = versionFrom)).getChangeSetId() > itemLatestVersion) continue;
                    if (versionTo instanceof ChangesetVersionSpec && (changesetVersionTo = (ChangesetVersionSpec)versionTo).getChangeSetId() > itemLatestVersion) {
                        versionTo = new ChangesetVersionSpec(itemLatestVersion);
                    }
                    LatestVersionSpec itemVersion = LatestVersionSpec.INSTANCE;
                    RecursionType recursionType = localPath2ExtendedItem.getKey().isDirectory() ? RecursionType.Full : null;
                    ItemSpec itemSpec = VersionControlServer.createItemSpec(extendedItem.getSitem(), recursionType);
                    List<Changeset> changeSets = workspace.getServer().getVCS().queryHistory(workspace.getName(), workspace.getOwnerName(), itemSpec, settings.getUserFilter(), itemVersion, versionFrom, versionTo, maxCount, this.myProject, TFSBundle.message("loading.history", new Object[0]));
                    for (Changeset changeset : changeSets) {
                        TFSChangeList newList = new TFSChangeList(workspace, changeset.getCset(), changeset.getOwner(), changeset.getDate().getTime(), changeset.getComment(), this.myVcs);
                        consumer.consume((Object)newList);
                    }
                }
            }
        }
        catch (TfsException e) {
            throw new VcsException((Throwable)e);
        }
        finally {
            consumer.finished();
        }
    }

    public List<TFSChangeList> getCommittedChanges(ChangeBrowserSettings settings, RepositoryLocation location, int maxCount) throws VcsException {
        final ArrayList<TFSChangeList> result = new ArrayList<TFSChangeList>();
        this.loadCommittedChanges(settings, location, maxCount, new AsynchConsumer<CommittedChangeList>(){

            public void finished() {
            }

            public void consume(CommittedChangeList committedChangeList) {
                result.add((TFSChangeList)committedChangeList);
            }
        });
        return result;
    }

    private int getLatestChangesetId(WorkspaceInfo workspace, String user, ExtendedItem extendedItem) throws TfsException {
        if (extendedItem.getType() == ItemType.File) {
            return extendedItem.getLatest();
        }
        LatestVersionSpec itemVersion = LatestVersionSpec.INSTANCE;
        ChangesetVersionSpec versionFrom = new ChangesetVersionSpec(1);
        LatestVersionSpec versionTo = LatestVersionSpec.INSTANCE;
        boolean maxCount = true;
        ItemSpec itemSpec = VersionControlServer.createItemSpec(extendedItem.getSitem(), RecursionType.Full);
        List<Changeset> changeSets = workspace.getServer().getVCS().queryHistory(workspace.getName(), workspace.getOwnerName(), itemSpec, user, itemVersion, versionFrom, versionTo, 1, this.myProject, TFSBundle.message("loading.history", new Object[0]));
        return changeSets.get(0).getCset();
    }

    public ChangeListColumn[] getColumns() {
        return new ChangeListColumn[]{new ChangeListColumn.ChangeListNumberColumn("Revision"), ChangeListColumn.NAME, ChangeListColumn.DATE, ChangeListColumn.DESCRIPTION};
    }

    public int getFormatVersion() {
        return 1;
    }

    public void writeChangeList(DataOutput stream, TFSChangeList list) throws IOException {
        list.writeToStream(stream);
    }

    public TFSChangeList readChangeList(RepositoryLocation location, DataInput stream) throws IOException {
        return new TFSChangeList(this.myVcs, stream);
    }

    public boolean isMaxCountSupported() {
        return true;
    }

    public Collection<FilePath> getIncomingFiles(RepositoryLocation location) throws VcsException {
        return null;
    }

    public boolean refreshCacheByNumber() {
        return true;
    }

    public String getChangelistTitle() {
        return "Changelist";
    }

    public boolean isChangeLocallyAvailable(FilePath filePath, @Nullable VcsRevisionNumber localRevision, VcsRevisionNumber changeRevision, TFSChangeList changeList) {
        return localRevision != null && localRevision.compareTo((Object)changeRevision) >= 0;
    }

    public boolean refreshIncomingWithCommitted() {
        return false;
    }

    public int getUnlimitedCountValue() {
        return 0;
    }

    @Nullable
    public VcsCommittedViewAuxiliary createActions(DecoratorManager manager, RepositoryLocation location) {
        return null;
    }
}

