/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ObjectUtils;
import com.microsoft.tfs.core.config.persistence.DefaultPersistenceStoreProvider;
import com.microsoft.tfs.core.httpclient.DefaultNTCredentials;
import com.microsoft.tfs.core.httpclient.UsernamePasswordCredentials;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.core.configuration.Credentials;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;

public class TfsSdkManager {
    private TfsSdkManager() {
        TfsSdkManager.setupNativeLibrariesPath();
    }

    @NotNull
    public File getCacheFile() {
        File file = new File(DefaultPersistenceStoreProvider.INSTANCE.getCachePersistenceStore().getStoreFile(), "VersionControl.config");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TfsSdkManager", "getCacheFile"));
        }
        return file;
    }

    @NotNull
    public com.microsoft.tfs.core.httpclient.Credentials getCredentials(@NotNull ServerInfo server) {
        DefaultNTCredentials result;
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "org/jetbrains/tfsIntegration/core/TfsSdkManager", "getCredentials"));
        }
        Credentials credentials = (Credentials)ObjectUtils.assertNotNull((Object)TFSConfigurationManager.getInstance().getCredentials(server.getUri()));
        switch (credentials.getType()) {
            case NtlmNative: {
                result = new DefaultNTCredentials();
                break;
            }
            case NtlmExplicit: 
            case Alternate: {
                result = new UsernamePasswordCredentials(credentials.getQualifiedUsername(), credentials.getPassword());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown credentials type " + (Object)((Object)credentials.getType()));
            }
        }
        DefaultNTCredentials defaultNTCredentials = result;
        if (defaultNTCredentials == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TfsSdkManager", "getCredentials"));
        }
        return defaultNTCredentials;
    }

    @NotNull
    public static TfsSdkManager getInstance() {
        TfsSdkManager tfsSdkManager = (TfsSdkManager)ServiceManager.getService(TfsSdkManager.class);
        if (tfsSdkManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TfsSdkManager", "getInstance"));
        }
        return tfsSdkManager;
    }

    public static void activate() {
        TfsSdkManager.getInstance();
    }

    private static void setupNativeLibrariesPath() {
        File nativeLibrariesPath = new File(TfsSdkManager.getPluginDirectory(), FileUtil.toSystemDependentName((String)"lib/native"));
        System.setProperty("com.microsoft.tfs.jni.native.base-directory", nativeLibrariesPath.getPath());
    }

    @NotNull
    private static File getPluginDirectory() {
        PluginId pluginId = PluginId.getId((String)"TFS");
        IdeaPluginDescriptor pluginDescriptor = (IdeaPluginDescriptor)ObjectUtils.assertNotNull((Object)PluginManager.getPlugin((PluginId)pluginId));
        File file = pluginDescriptor.isBundled() ? PluginPathManager.getPluginHome((String)"tfsIntegration") : (File)ObjectUtils.assertNotNull((Object)pluginDescriptor.getPath());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/TfsSdkManager", "getPluginDirectory"));
        }
        return file;
    }
}

