/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.core.tfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.config.TfsServerConnectionHelper;
import org.jetbrains.tfsIntegration.core.TfsSdkManager;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkingFolderInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkstationCacheReader;
import org.jetbrains.tfsIntegration.exceptions.DuplicateMappingException;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.exceptions.WorkspaceHasNoMappingException;
import org.jetbrains.tfsIntegration.xmlutil.XmlUtil;

public class Workstation {
    public static boolean PRESERVE_CONFIG_FILE = false;
    private static final Logger LOG = Logger.getInstance((String)Workstation.class.getName());
    @NotNull
    private final List<ServerInfo> myServerInfos = Workstation.loadCache();
    @Nullable
    private Ref<FilePath> myDuplicateMappedPath;
    private static String ourComputerName;

    private Workstation() {
    }

    @NotNull
    public static Workstation getInstance() {
        Workstation workstation = WorkstationHolder.ourInstance;
        if (workstation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "getInstance"));
        }
        return workstation;
    }

    @NotNull
    public List<ServerInfo> getServers() {
        List<ServerInfo> list = Collections.unmodifiableList(this.myServerInfos);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "getServers"));
        }
        return list;
    }

    @Nullable
    public ServerInfo getServer(@NotNull URI uri) {
        if (uri == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "getServer"));
        }
        return (ServerInfo)ContainerUtil.find(this.getServers(), serverInfo -> {
            if (uri == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uri", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "lambda$getServer$0"));
            }
            return serverInfo.getUri().equals(uri);
        });
    }

    @NotNull
    private List<WorkspaceInfo> getAllWorkspacesForCurrentOwnerAndComputer(boolean showLoginIfNoCredentials) {
        ArrayList result = ContainerUtil.newArrayList();
        for (ServerInfo server : this.getServers()) {
            if (showLoginIfNoCredentials && server.getQualifiedUsername() == null) {
                try {
                    TfsServerConnectionHelper.ensureAuthenticated(null, server.getUri(), false);
                }
                catch (TfsException e) {
                    continue;
                }
            }
            result.addAll(server.getWorkspacesForCurrentOwnerAndComputer());
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "getAllWorkspacesForCurrentOwnerAndComputer"));
        }
        return arrayList;
    }

    @NotNull
    private static List<ServerInfo> loadCache() {
        File cacheFile = Workstation.getCacheFile(true);
        if (cacheFile != null) {
            List<ServerInfo> list;
            try {
                WorkstationCacheReader reader = new WorkstationCacheReader();
                XmlUtil.parseFile(cacheFile, reader);
                list = reader.getServers();
            }
            catch (Exception e) {
                LOG.info("Cannot read workspace cache", (Throwable)e);
            }
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "loadCache"));
            }
            return list;
        }
        ArrayList arrayList = ContainerUtil.newArrayList();
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "loadCache"));
        }
        return arrayList;
    }

    @Nullable
    private static File getCacheFile(boolean existingOnly) {
        if (PRESERVE_CONFIG_FILE) {
            return null;
        }
        File cacheFile = TfsSdkManager.getInstance().getCacheFile();
        return cacheFile.exists() || !existingOnly ? cacheFile : null;
    }

    void update() {
        this.invalidateDuplicateMappedPath();
        File cacheFile = Workstation.getCacheFile(false);
        if (cacheFile != null) {
            if (!cacheFile.getParentFile().exists()) {
                cacheFile.getParentFile().mkdirs();
            }
            try {
                Element serversElement = new Element("Servers");
                for (ServerInfo serverInfo : this.getServers()) {
                    Element serverInfoElement = new Element("ServerInfo").setAttribute("uri", serverInfo.getUri().toString()).setAttribute("repositoryGuid", serverInfo.getGuid());
                    serversElement.addContent(serverInfoElement);
                    for (WorkspaceInfo workspaceInfo : serverInfo.getWorkspaces()) {
                        Element workspaceInfoElement = new Element("WorkspaceInfo").setAttribute("computer", workspaceInfo.getComputer()).setAttribute("ownerName", workspaceInfo.getOwnerName()).setAttribute("LastSavedCheckinTimeStamp", ConverterUtil.convertToString((Calendar)workspaceInfo.getTimestamp())).setAttribute("name", workspaceInfo.getName()).setAttribute("isLocalWorkspace", String.valueOf(workspaceInfo.isLocal())).setAttribute("options", String.valueOf(workspaceInfo.getOptions())).setAttribute("comment", StringUtil.notNullize((String)workspaceInfo.getComment())).setAttribute("ownerDisplayName", StringUtil.notNullize((String)workspaceInfo.getOwnerDisplayName()));
                        Workstation.setIfNotNull(workspaceInfoElement, "securityToken", workspaceInfo.getSecurityToken());
                        Workstation.addItems(workspaceInfoElement, "MappedPaths", "MappedPath", "path", workspaceInfo.getWorkingFoldersCached(), folderInfo -> folderInfo.getLocalPath().getPresentableUrl());
                        Workstation.addItems(workspaceInfoElement, "OwnerAliases", "OwnerAlias", "OwnerAlias", workspaceInfo.getOwnerAliases(), Functions.TO_STRING());
                        serverInfoElement.addContent(workspaceInfoElement);
                    }
                }
                Document document = new Document().setRootElement(new Element("VersionControlServer").addContent(serversElement));
                Workstation.saveDocument(cacheFile, document);
            }
            catch (IOException e) {
                LOG.info("Cannot update workspace cache", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveDocument(@NotNull File cacheFile, @NotNull Document document) throws IOException {
        if (cacheFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cacheFile", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "saveDocument"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "saveDocument"));
        }
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(cacheFile));){
            XMLOutputter o = JDOMUtil.createOutputter((String)"\n");
            o.setFormat(o.getFormat().setOmitDeclaration(true));
            o.output(document, (OutputStream)stream);
        }
    }

    private static <T> void addItems(@NotNull Element parentElement, @NotNull String elementName, @NotNull String itemElementName, @NotNull String itemAttributeName, @NotNull List<T> items, @NotNull Function<T, String> valueProvider) {
        if (parentElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentElement", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "addItems"));
        }
        if (elementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementName", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "addItems"));
        }
        if (itemElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemElementName", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "addItems"));
        }
        if (itemAttributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemAttributeName", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "addItems"));
        }
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "addItems"));
        }
        if (valueProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueProvider", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "addItems"));
        }
        Element element = new Element(elementName);
        parentElement.addContent(element);
        for (T item : items) {
            element.addContent(new Element(itemElementName).setAttribute(itemAttributeName, StringUtil.notNullize((String)((String)valueProvider.fun(item)))));
        }
    }

    private static void setIfNotNull(@NotNull Element element, @NotNull String attributeName, @Nullable String value) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "setIfNotNull"));
        }
        if (attributeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attributeName", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "setIfNotNull"));
        }
        if (value != null) {
            element.setAttribute(attributeName, value);
        }
    }

    public void addServer(ServerInfo serverInfo) {
        this.myServerInfos.add(serverInfo);
        this.update();
    }

    public void removeServer(ServerInfo serverInfo) {
        this.myServerInfos.remove(serverInfo);
        TFSConfigurationManager.getInstance().remove(serverInfo.getUri());
        this.update();
    }

    public static synchronized String getComputerName() {
        if (ourComputerName == null) {
            try {
                InetAddress address = InetAddress.getLocalHost();
                String hostName = address.getHostName();
                int i = hostName.indexOf(46);
                if (i != -1) {
                    hostName = hostName.substring(0, i);
                }
                ourComputerName = hostName;
            }
            catch (UnknownHostException e) {
                throw new RuntimeException("Cannot retrieve host name.");
            }
        }
        return ourComputerName;
    }

    @NotNull
    public Collection<WorkspaceInfo> findWorkspacesCached(@NotNull FilePath localPath, boolean considerChildMappings) {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "findWorkspacesCached"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (WorkspaceInfo workspace : this.getAllWorkspacesForCurrentOwnerAndComputer(false)) {
            if (!workspace.hasMappingCached(localPath, considerChildMappings)) continue;
            result.add(workspace);
            if (considerChildMappings) continue;
            break;
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "findWorkspacesCached"));
        }
        return arrayList;
    }

    @NotNull
    public Collection<WorkspaceInfo> findWorkspaces(@NotNull FilePath localPath, boolean considerChildMappings, Object projectOrComponent) throws TfsException {
        if (localPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localPath", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "findWorkspaces"));
        }
        this.checkDuplicateMappings();
        Collection<WorkspaceInfo> resultCached = this.findWorkspacesCached(localPath, considerChildMappings);
        if (!resultCached.isEmpty()) {
            for (WorkspaceInfo workspace : resultCached) {
                if (workspace.hasMapping(localPath, considerChildMappings, projectOrComponent)) continue;
                throw new WorkspaceHasNoMappingException(workspace);
            }
            Collection<WorkspaceInfo> collection = resultCached;
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "findWorkspaces"));
            }
            return collection;
        }
        ArrayList result = ContainerUtil.newArrayList();
        ArrayList serversToSkip = ContainerUtil.newArrayList();
        for (WorkspaceInfo workspace : this.getAllWorkspacesForCurrentOwnerAndComputer(true)) {
            ArrayList arrayList;
            if (serversToSkip.contains(workspace.getServer())) continue;
            try {
                if (!workspace.hasMapping(localPath, considerChildMappings, projectOrComponent)) continue;
                result.add(workspace);
                if (considerChildMappings) continue;
                arrayList = result;
            }
            catch (TfsException e) {
                serversToSkip.add(workspace.getServer());
                continue;
            }
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "findWorkspaces"));
            }
            return arrayList;
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/core/tfs/Workstation", "findWorkspaces"));
        }
        return arrayList;
    }

    public void checkDuplicateMappings() throws DuplicateMappingException {
        if (this.myDuplicateMappedPath == null) {
            this.myDuplicateMappedPath = Ref.create((Object)this.findDuplicateMappedPath());
        }
        if (!this.myDuplicateMappedPath.isNull()) {
            throw new DuplicateMappingException((FilePath)this.myDuplicateMappedPath.get());
        }
    }

    private void invalidateDuplicateMappedPath() {
        this.myDuplicateMappedPath = null;
    }

    @Nullable
    private FilePath findDuplicateMappedPath() {
        ArrayList otherServersPaths = ContainerUtil.newArrayList();
        for (ServerInfo server : this.getServers()) {
            ArrayList currentServerPaths = ContainerUtil.newArrayList();
            for (WorkspaceInfo workspace : server.getWorkspacesForCurrentOwnerAndComputer()) {
                for (WorkingFolderInfo workingFolder : workspace.getWorkingFoldersCached()) {
                    FilePath currentServerPath = workingFolder.getLocalPath();
                    for (FilePath otherServerPath : otherServersPaths) {
                        if (currentServerPath.isUnder(otherServerPath, false)) {
                            return currentServerPath;
                        }
                        if (!otherServerPath.isUnder(currentServerPath, false)) continue;
                        return otherServerPath;
                    }
                    currentServerPaths.add(currentServerPath);
                }
            }
            otherServersPaths.addAll(currentServerPaths);
        }
        return null;
    }

    private static class WorkstationHolder {
        private static final Workstation ourInstance = new Workstation();

        private WorkstationHolder() {
        }
    }
}

