/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Annotation;
import com.microsoft.schemas.teamfoundation._2005._06.versioncontrol.clientservices._03.Item;
import icons.TFSIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.checkin.CheckinPoliciesManager;
import org.jetbrains.tfsIntegration.checkin.DuplicatePolicyIdException;
import org.jetbrains.tfsIntegration.checkin.PolicyParseException;
import org.jetbrains.tfsIntegration.checkin.StatefulPolicyDescriptor;
import org.jetbrains.tfsIntegration.checkin.StatefulPolicyParser;
import org.jetbrains.tfsIntegration.config.TfsServerConnectionHelper;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.configuration.TFSConfigurationManager;
import org.jetbrains.tfsIntegration.core.configuration.TfsCheckinPoliciesCompatibility;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.TfsExecutionUtil;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.core.tfs.Workstation;
import org.jetbrains.tfsIntegration.exceptions.OperationFailedException;
import org.jetbrains.tfsIntegration.exceptions.TfsException;
import org.jetbrains.tfsIntegration.exceptions.UserCancelledException;
import org.jetbrains.tfsIntegration.exceptions.WorkspaceNotFoundException;
import org.jetbrains.tfsIntegration.ui.CheckInPoliciesDialog;
import org.jetbrains.tfsIntegration.ui.ProxySettingsDialog;
import org.jetbrains.tfsIntegration.ui.UiConstants;
import org.jetbrains.tfsIntegration.ui.WorkspaceDialog;
import org.jetbrains.tfsIntegration.ui.treetable.CellRenderer;
import org.jetbrains.tfsIntegration.ui.treetable.ContentProvider;
import org.jetbrains.tfsIntegration.ui.treetable.CustomTreeTable;
import org.jetbrains.tfsIntegration.ui.treetable.TreeTableColumn;
import org.jetbrains.tfsIntegration.webservice.TfsRequestManager;

public class ManageWorkspacesForm {
    private static final TreeTableColumn<Object> COLUMN_SERVER_WORKSPACE = new TreeTableColumn<Object>("Server / workspace", 200){

        @Override
        public String getPresentableString(Object value) {
            if (value instanceof ServerInfo) {
                ServerInfo server = (ServerInfo)value;
                if (server.getQualifiedUsername() != null) {
                    return MessageFormat.format("{0} [{1}]", server.getPresentableUri(), server.getQualifiedUsername());
                }
                return server.getPresentableUri();
            }
            if (value instanceof WorkspaceInfo) {
                return ((WorkspaceInfo)value).getName();
            }
            return "";
        }
    };
    private static final TreeTableColumn<Object> COLUMN_SERVER = new TreeTableColumn<Object>("Server", 200){

        @Override
        public String getPresentableString(Object value) {
            if (value instanceof ServerInfo) {
                ServerInfo server = (ServerInfo)value;
                if (server.getQualifiedUsername() != null) {
                    return MessageFormat.format("{0} [{1}]", server.getPresentableUri(), server.getQualifiedUsername());
                }
                return server.getPresentableUri();
            }
            return "";
        }
    };
    private static final TreeTableColumn<Object> COLUMN_COMMENT = new TreeTableColumn<Object>("Workspace comment", 100){

        @Override
        public String getPresentableString(Object value) {
            if (value instanceof WorkspaceInfo) {
                return ((WorkspaceInfo)value).getComment();
            }
            return "";
        }
    };
    private JPanel myContentPane;
    private JButton myAddServerButton;
    private JButton myRemoveServerButton;
    private JButton myProxySettingsButton;
    private JButton myCreateWorkspaceButton;
    private JButton myEditWorkspaceButton;
    private JButton myDeleteWorkspaceButton;
    private CustomTreeTable<Object> myTable;
    private JPanel myWorkspacesPanel;
    private JButton myCheckInPoliciesButton;
    private JButton myReloadWorkspacesButton;
    private final Project myProject;
    private boolean myShowWorkspaces = true;
    private final EventDispatcher<Listener> myEventDispatcher;
    private final ListSelectionListener mySelectionListener;
    private final ContentProvider<Object> myContentProvider;

    public ManageWorkspacesForm(Project project, boolean editPoliciesButtonVisible) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(Listener.class);
        this.mySelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ManageWorkspacesForm.this.updateButtons();
                ((Listener)ManageWorkspacesForm.this.myEventDispatcher.getMulticaster()).selectionChanged();
            }
        };
        this.myContentProvider = new ContentProvider<Object>(){

            @Override
            public Collection<?> getRoots() {
                ArrayList<ServerInfo> servers = new ArrayList<ServerInfo>(Workstation.getInstance().getServers());
                Collections.sort(servers, new Comparator<ServerInfo>(){

                    @Override
                    public int compare(ServerInfo s1, ServerInfo s2) {
                        return s1.getPresentableUri().compareTo(s2.getPresentableUri());
                    }
                });
                return servers;
            }

            @Override
            public Collection<?> getChildren(@NotNull Object parent) {
                if (parent == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/tfsIntegration/ui/ManageWorkspacesForm$5", "getChildren"));
                }
                if (parent instanceof ServerInfo && ManageWorkspacesForm.this.myShowWorkspaces) {
                    ArrayList<WorkspaceInfo> workspaces = new ArrayList<WorkspaceInfo>(((ServerInfo)parent).getWorkspacesForCurrentOwnerAndComputer());
                    Collections.sort(workspaces, new Comparator<WorkspaceInfo>(){

                        @Override
                        public int compare(WorkspaceInfo o1, WorkspaceInfo o2) {
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    return workspaces;
                }
                return Collections.emptyList();
            }
        };
        this.myProject = project;
        this.myAddServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageWorkspacesForm.this.addServer();
            }
        });
        this.myRemoveServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageWorkspacesForm.this.removeServer(ManageWorkspacesForm.this.getSelectedServer());
            }
        });
        this.myProxySettingsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageWorkspacesForm.this.changeProxySettings(ManageWorkspacesForm.this.getSelectedServer());
            }
        });
        this.myCreateWorkspaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServerInfo server = ManageWorkspacesForm.this.getSelectedServer();
                if (server == null) {
                    server = ManageWorkspacesForm.this.getSelectedWorkspace().getServer();
                }
                ManageWorkspacesForm.this.createWorkspace(server);
            }
        });
        this.myEditWorkspaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageWorkspacesForm.this.editWorkspace(ManageWorkspacesForm.this.getSelectedWorkspace());
            }
        });
        this.myDeleteWorkspaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageWorkspacesForm.this.deleteWorkspace(ManageWorkspacesForm.this.getSelectedWorkspace());
            }
        });
        this.myCheckInPoliciesButton.setVisible(editPoliciesButtonVisible);
        this.myCheckInPoliciesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageWorkspacesForm.this.configureCheckinPolicies();
            }
        });
        this.myReloadWorkspacesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageWorkspacesForm.this.reloadWorkspaces(ManageWorkspacesForm.this.getSelectedServer());
            }
        });
        this.updateButtons();
    }

    private void reloadWorkspaces(ServerInfo server) {
        try {
            Object selection = this.getSelectedObject();
            server.refreshWorkspacesForCurrentOwner(this.myContentPane, true);
            this.updateControls(selection);
        }
        catch (UserCancelledException selection) {
        }
        catch (TfsException e) {
            Messages.showErrorDialog((Component)this.myContentPane, (String)e.getMessage(), (String)TFSBundle.message("reload.workspaces.title", new Object[0]));
        }
    }

    private void createUIComponents() {
        this.myTable = new CustomTreeTable<Object>(new CellRendererImpl(), false, true);
        this.myTable.getSelectionModel().setSelectionMode(0);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                WorkspaceInfo workspace = ManageWorkspacesForm.this.getSelectedWorkspace();
                if (workspace != null) {
                    ManageWorkspacesForm.this.editWorkspace(workspace);
                    return true;
                }
                return false;
            }
        }.installOn(this.myTable);
    }

    public void setShowWorkspaces(boolean showWorkspaces) {
        this.myShowWorkspaces = showWorkspaces;
        this.myWorkspacesPanel.setVisible(this.myShowWorkspaces);
        this.myReloadWorkspacesButton.setVisible(this.myShowWorkspaces);
        List columns = this.myShowWorkspaces ? Arrays.asList(COLUMN_SERVER_WORKSPACE, COLUMN_COMMENT) : Collections.singletonList(COLUMN_SERVER);
        this.myTable.initialize(columns, this.myContentProvider);
        this.myTable.getSelectionModel().addListSelectionListener(this.mySelectionListener);
        this.myTable.expandAll();
    }

    private void updateControls(Object selectedServerOrWorkspace) {
        this.myTable.updateContent();
        this.myTable.getSelectionModel().addListSelectionListener(this.mySelectionListener);
        this.myTable.expandAll();
        Object newSelection = null;
        for (int i = 0; i < this.myTable.getModel().getRowCount(); ++i) {
            Object o = ((DefaultMutableTreeNode)this.myTable.getModel().getValueAt(i, 0)).getUserObject();
            if (Comparing.equal((Object)o, (Object)selectedServerOrWorkspace)) {
                newSelection = o;
                break;
            }
            if (!(selectedServerOrWorkspace instanceof WorkspaceInfo)) continue;
            WorkspaceInfo selectedWorkspace = (WorkspaceInfo)selectedServerOrWorkspace;
            if (selectedWorkspace.getServer().equals(o)) {
                newSelection = o;
            }
            if (!(o instanceof WorkspaceInfo)) continue;
            WorkspaceInfo workspace = (WorkspaceInfo)o;
            if (!selectedWorkspace.getName().equals(workspace.getName()) || !selectedWorkspace.getOwnerName().equals(workspace.getOwnerName()) || !selectedWorkspace.getServer().equals(workspace.getServer())) continue;
            newSelection = o;
            break;
        }
        this.myTable.select(newSelection);
    }

    private void updateButtons() {
        ServerInfo selectedServer = this.getSelectedServer();
        WorkspaceInfo selectedWorkspace = this.getSelectedWorkspace();
        this.myRemoveServerButton.setEnabled(selectedServer != null);
        this.myProxySettingsButton.setEnabled(selectedServer != null);
        this.myCreateWorkspaceButton.setEnabled(selectedServer != null || selectedWorkspace != null);
        this.myEditWorkspaceButton.setEnabled(selectedWorkspace != null);
        this.myDeleteWorkspaceButton.setEnabled(selectedWorkspace != null);
        this.myCheckInPoliciesButton.setEnabled(selectedServer != null);
        this.myReloadWorkspacesButton.setEnabled(selectedServer != null);
    }

    private void addServer() {
        TfsServerConnectionHelper.AddServerResult result = TfsServerConnectionHelper.addServer(this.getContentPane());
        if (result == null) {
            return;
        }
        if (result.workspacesLoadError != null) {
            Messages.showErrorDialog((Component)this.myContentPane, (String)TFSBundle.message("failed.to.load.workspaces", result.workspacesLoadError), (String)TFSBundle.message("add.server.title", new Object[0]));
        }
        TFSConfigurationManager.getInstance().storeCredentials(result.uri, result.authorizedCredentials);
        ServerInfo newServer = new ServerInfo(result.uri, result.instanceId, result.workspaces, result.authorizedCredentials.getQualifiedUsername(), result.beans);
        Workstation.getInstance().addServer(newServer);
        List<WorkspaceInfo> workspaces = newServer.getWorkspacesForCurrentOwnerAndComputer();
        this.updateControls(workspaces.isEmpty() ? newServer : workspaces.iterator().next());
    }

    private void removeServer(@NotNull ServerInfo server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "org/jetbrains/tfsIntegration/ui/ManageWorkspacesForm", "removeServer"));
        }
        String warning = TFSBundle.message("remove.server.prompt", server.getPresentableUri());
        if (Messages.showYesNoDialog((Component)this.myContentPane, (String)warning, (String)TFSBundle.message("remove.server.title", new Object[0]), (Icon)Messages.getWarningIcon()) == 0) {
            Workstation.getInstance().removeServer(server);
            this.updateControls(null);
        }
    }

    private void changeProxySettings(@NotNull ServerInfo server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "org/jetbrains/tfsIntegration/ui/ManageWorkspacesForm", "changeProxySettings"));
        }
        ProxySettingsDialog d = new ProxySettingsDialog(this.myProject, server.getUri());
        if (d.showAndGet()) {
            TFSConfigurationManager.getInstance().setProxyUri(server.getUri(), d.getProxyUri());
        }
    }

    private void createWorkspace(@NotNull ServerInfo server) {
        WorkspaceDialog d;
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "org/jetbrains/tfsIntegration/ui/ManageWorkspacesForm", "createWorkspace"));
        }
        boolean update = false;
        if (TfsRequestManager.shouldShowLoginDialog(server.getUri())) {
            update = true;
            try {
                TfsServerConnectionHelper.ensureAuthenticated(this.myContentPane, server.getUri(), true);
            }
            catch (UserCancelledException e) {
                return;
            }
            catch (TfsException e) {
                Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage(), (String)TFSBundle.message("create.workspace", new Object[0]));
                return;
            }
        }
        if ((d = new WorkspaceDialog(this.myProject, server)).showAndGet()) {
            try {
                WorkspaceInfo newWorkspace = new WorkspaceInfo(server, server.getQualifiedUsername(), Workstation.getComputerName());
                newWorkspace.setName(d.getWorkspaceName());
                newWorkspace.setLocation(d.getWorkspaceLocation());
                newWorkspace.setComment(d.getWorkspaceComment());
                newWorkspace.setWorkingFolders(d.getWorkingFolders());
                newWorkspace.saveToServer(this.myContentPane, null);
                this.updateControls(newWorkspace);
                return;
            }
            catch (UserCancelledException newWorkspace) {
            }
            catch (TfsException e) {
                Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)TFSBundle.message("create.workspace.title", new Object[0]));
            }
        }
        if (update) {
            this.updateControls(null);
        }
    }

    private void editWorkspace(@NotNull WorkspaceInfo workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workspace", "org/jetbrains/tfsIntegration/ui/ManageWorkspacesForm", "editWorkspace"));
        }
        try {
            workspace.loadFromServer(this.myContentPane, true);
        }
        catch (WorkspaceNotFoundException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)TFSBundle.message("edit.workspace.title", new Object[0]));
            try {
                workspace.getServer().refreshWorkspacesForCurrentOwner(this.myContentPane, true);
                this.updateControls(null);
            }
            catch (UserCancelledException userCancelledException) {
            }
            catch (TfsException e2) {
                Messages.showErrorDialog((Component)this.myContentPane, (String)e2.getMessage(), (String)TFSBundle.message("reload.workspaces.title", new Object[0]));
            }
            return;
        }
        catch (UserCancelledException e) {
            return;
        }
        catch (TfsException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)TFSBundle.message("edit.workspace.title", new Object[0]));
            return;
        }
        WorkspaceInfo modifiedWorkspace = workspace.getCopy();
        WorkspaceDialog d = new WorkspaceDialog(this.myProject, modifiedWorkspace);
        if (d.showAndGet()) {
            modifiedWorkspace.setName(d.getWorkspaceName());
            modifiedWorkspace.setLocation(d.getWorkspaceLocation());
            modifiedWorkspace.setComment(d.getWorkspaceComment());
            modifiedWorkspace.setWorkingFolders(d.getWorkingFolders());
            try {
                modifiedWorkspace.saveToServer(this.myContentPane, workspace);
                this.updateControls(modifiedWorkspace);
            }
            catch (UserCancelledException userCancelledException) {
            }
            catch (TfsException e) {
                Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)TFSBundle.message("save.workspace.title", new Object[0]));
            }
        }
    }

    private void deleteWorkspace(@NotNull WorkspaceInfo workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workspace", "org/jetbrains/tfsIntegration/ui/ManageWorkspacesForm", "deleteWorkspace"));
        }
        if (Messages.showYesNoDialog((Component)this.myContentPane, (String)TFSBundle.message("delete.workspace.prompt", workspace.getName()), (String)TFSBundle.message("delete.workspace.title", new Object[0]), (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        try {
            workspace.getServer().deleteWorkspace(workspace, this.myContentPane, true);
            this.updateControls(workspace);
        }
        catch (UserCancelledException userCancelledException) {
        }
        catch (TfsException e) {
            Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)TFSBundle.message("delete.workspace.title", new Object[0]));
        }
    }

    @Nullable
    private Object getSelectedObject() {
        Collection<Object> selection;
        if (this.myTable.getSelectedRowCount() == 1 && (selection = this.myTable.getSelectedItems()).size() == 1) {
            return this.myTable.getSelectedItems().iterator().next();
        }
        return null;
    }

    @Nullable
    public WorkspaceInfo getSelectedWorkspace() {
        Object selectedObject = this.getSelectedObject();
        if (selectedObject instanceof WorkspaceInfo) {
            return (WorkspaceInfo)selectedObject;
        }
        return null;
    }

    @Nullable
    public ServerInfo getSelectedServer() {
        Object selectedObject = this.getSelectedObject();
        if (selectedObject instanceof ServerInfo) {
            return (ServerInfo)selectedObject;
        }
        if (selectedObject instanceof WorkspaceInfo) {
            return ((WorkspaceInfo)selectedObject).getServer();
        }
        return null;
    }

    public void setSelectedWorkspace(WorkspaceInfo workspace) {
        this.myTable.select(workspace);
    }

    public void setSelectedServer(ServerInfo server) {
        this.myTable.select(server);
    }

    public void selectFirstServer() {
        Collection<Object> servers = this.myContentProvider.getRoots();
        if (!servers.isEmpty()) {
            this.myTable.select(servers.iterator().next());
        }
    }

    public void selectFirstWorkspace() {
        Collection<Object> servers = this.myContentProvider.getRoots();
        for (Object server : servers) {
            Collection<Object> workspaces = this.myContentProvider.getChildren(server);
            if (workspaces.isEmpty()) continue;
            this.myTable.select(workspaces.iterator().next());
            break;
        }
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public void addSelectionListener(Listener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    private void configureCheckinPolicies() {
        Map<String, ProjectEntry> modifications;
        try {
            CheckinPoliciesManager.getInstalledPolicies();
        }
        catch (DuplicatePolicyIdException e) {
            String message = MessageFormat.format("Several checkin policies with the same id found: ''{0}''.\nPlease review your extensions.", e.getDuplicateId());
            Messages.showErrorDialog((Project)this.myProject, (String)message, (String)"Edit Checkin Policies");
            return;
        }
        final ServerInfo server = this.getSelectedServer();
        TfsExecutionUtil.Process<Map<String, ProjectEntry>> process = new TfsExecutionUtil.Process<Map<String, ProjectEntry>>(){

            @Override
            public Map<String, ProjectEntry> run() throws TfsException, VcsException {
                HashMap<String, ProjectEntry> entries = new HashMap<String, ProjectEntry>();
                List<Item> projectItems = server.getVCS().getChildItems("$/", true, ManageWorkspacesForm.this.myContentPane, null);
                if (projectItems.isEmpty()) {
                    throw new OperationFailedException("No team project found");
                }
                for (Item projectItem : projectItems) {
                    Collection<Annotation> overridesAnnotations;
                    ProjectEntry entry = new ProjectEntry();
                    Collection<Annotation> policiesAnnotations = server.getVCS().queryAnnotations("TeampriseCheckinPolicies", projectItem.getItem(), ManageWorkspacesForm.this.myContentPane, null, true);
                    if (!policiesAnnotations.isEmpty()) {
                        try {
                            entry.descriptors = StatefulPolicyParser.parseDescriptors(policiesAnnotations.iterator().next().getValue());
                        }
                        catch (PolicyParseException ex) {
                            String message = MessageFormat.format("Cannot load checkin policies definitions:\n{0}", ex.getMessage());
                            throw new OperationFailedException(message);
                        }
                    }
                    if (!(overridesAnnotations = server.getVCS().queryAnnotations("IntellijOverrides", projectItem.getItem(), ManageWorkspacesForm.this.myContentPane, null, true)).isEmpty()) {
                        try {
                            entry.policiesCompatibilityOverride = TfsCheckinPoliciesCompatibility.fromOverridesAnnotationValue(overridesAnnotations.iterator().next().getValue());
                        }
                        catch (IOException ex) {
                            String message = MessageFormat.format("Cannot load checkin policies overrides:\n{0}", ex.getMessage());
                            throw new OperationFailedException(message);
                        }
                        catch (JDOMException ex) {
                            String message = MessageFormat.format("Cannot load checkin policies overrides:\n{0}", ex.getMessage());
                            throw new OperationFailedException(message);
                        }
                    }
                    entries.put(projectItem.getItem(), entry);
                }
                return entries;
            }
        };
        TfsExecutionUtil.ResultWithError<Map<String, ProjectEntry>> loadResult = TfsExecutionUtil.executeInBackground("Loading Checkin Policies", this.myProject, process);
        if (loadResult.cancelled || loadResult.showDialogIfError("Configure Checkin Policies")) {
            return;
        }
        Map projectToDescriptors = (Map)loadResult.result;
        CheckInPoliciesDialog d = new CheckInPoliciesDialog(this.myProject, this.getSelectedServer(), projectToDescriptors);
        if (d.showAndGet() && !(modifications = d.getModifications()).isEmpty()) {
            TfsExecutionUtil.ResultWithError<Void> saveResult = TfsExecutionUtil.executeInBackground("Saving Checkin Policies", this.myProject, new TfsExecutionUtil.VoidProcess(){

                @Override
                public void run() throws TfsException, VcsException {
                    for (Map.Entry i : modifications.entrySet()) {
                        server.getVCS().deleteAnnotation((String)i.getKey(), "TeampriseCheckinPolicies", ManageWorkspacesForm.this.myContentPane, null);
                        server.getVCS().deleteAnnotation((String)i.getKey(), "IntellijOverrides", ManageWorkspacesForm.this.myContentPane, null);
                        ProjectEntry entry = (ProjectEntry)i.getValue();
                        if (!entry.descriptors.isEmpty()) {
                            String annotationValue = StatefulPolicyParser.saveDescriptors(entry.descriptors);
                            server.getVCS().createAnnotation((String)i.getKey(), "TeampriseCheckinPolicies", annotationValue, ManageWorkspacesForm.this.myContentPane, null);
                        }
                        if (entry.policiesCompatibilityOverride == null) continue;
                        server.getVCS().createAnnotation((String)i.getKey(), "IntellijOverrides", entry.policiesCompatibilityOverride.toOverridesAnnotationValue(), ManageWorkspacesForm.this.myContentPane, null);
                    }
                }
            });
            saveResult.showDialogIfError("Save Checkin Policies");
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JPanel jPanel;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JButton jButton7;
        JButton jButton8;
        JPanel jPanel2;
        this.createUIComponents();
        this.myContentPane = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(0, 0, 3, 1, 0, 3, 7, 7, null, null, null));
        CustomTreeTable<Object> customTreeTable = this.myTable;
        jBScrollPane.setViewportView((Component)((Object)customTreeTable));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(6, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEmptyBorder(), (String)"Team Servers", (int)0, (int)0, null, null));
        this.myAddServerButton = jButton8 = new JButton();
        jButton8.setText("Add...");
        jButton8.setMnemonic('A');
        jButton8.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton8, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveServerButton = jButton7 = new JButton();
        jButton7.setText("Remove");
        jButton7.setMnemonic('R');
        jButton7.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jButton7, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myProxySettingsButton = jButton6 = new JButton();
        jButton6.setText("TFS Proxy...");
        jButton6.setMnemonic('P');
        jButton6.setDisplayedMnemonicIndex(4);
        jPanel3.add((Component)jButton6, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCheckInPoliciesButton = jButton5 = new JButton();
        jButton5.setText("Checkin Policies...");
        jButton5.setMnemonic('H');
        jButton5.setDisplayedMnemonicIndex(1);
        jPanel3.add((Component)jButton5, new GridConstraints(5, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myReloadWorkspacesButton = jButton4 = new JButton();
        jButton4.setText("Reload workspaces");
        jButton4.setMnemonic('L');
        jButton4.setDisplayedMnemonicIndex(2);
        jPanel3.add((Component)jButton4, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
        this.myWorkspacesPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEmptyBorder(), (String)"Workspaces", (int)0, (int)0, null, null));
        this.myCreateWorkspaceButton = jButton3 = new JButton();
        jButton3.setText("Create...");
        jButton3.setMnemonic('C');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myEditWorkspaceButton = jButton2 = new JButton();
        jButton2.setText("Edit...");
        jButton2.setMnemonic('E');
        jButton2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myDeleteWorkspaceButton = jButton = new JButton();
        jButton.setText("Delete");
        jButton.setMnemonic('D');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton, new GridConstraints(2, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private static class CellRendererImpl
    extends CellRenderer<Object> {
        private CellRendererImpl() {
        }

        @Override
        protected void render(CustomTreeTable<Object> treeTable, TreeTableColumn<Object> column, Object value, JLabel cell) {
            super.render(treeTable, column, value, cell);
            if (column == COLUMN_SERVER_WORKSPACE || column == COLUMN_SERVER) {
                if (value instanceof ServerInfo) {
                    cell.setIcon(TFSIcons.Teamserver);
                } else if (value instanceof WorkspaceInfo) {
                    cell.setIcon(UiConstants.ICON_FILE);
                }
            }
        }
    }

    public static class ProjectEntry {
        public List<StatefulPolicyDescriptor> descriptors = new ArrayList<StatefulPolicyDescriptor>();
        @Nullable
        public TfsCheckinPoliciesCompatibility policiesCompatibilityOverride;
    }

    public static interface Listener
    extends EventListener {
        public void selectionChanged();
    }
}

