/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.microsoft.tfs.core.clients.workitem.project.Project;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryDefinition;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryFolder;
import com.microsoft.tfs.core.clients.workitem.queryhierarchy.QueryItem;
import com.microsoft.tfs.core.ws.runtime.exceptions.ProxyException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.tfs.TfsUtil;
import org.jetbrains.tfsIntegration.core.tfs.VersionControlPath;
import org.jetbrains.tfsIntegration.ui.BaseQueryNode;
import org.jetbrains.tfsIntegration.ui.QueriesTreeContext;
import org.jetbrains.tfsIntegration.ui.SavedQueryDefinitionNode;
import org.jetbrains.tfsIntegration.ui.servertree.TfsErrorTreeNode;

public class SavedQueryFolderNode
extends BaseQueryNode {
    @Nullable
    private final QueryFolder myQueryFolder;
    @Nullable
    private final String myProjectName;

    public SavedQueryFolderNode(@NotNull QueriesTreeContext context, @NotNull QueryFolder folder) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/tfsIntegration/ui/SavedQueryFolderNode", "<init>"));
        }
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "org/jetbrains/tfsIntegration/ui/SavedQueryFolderNode", "<init>"));
        }
        super(context);
        this.myQueryFolder = folder;
        this.myProjectName = null;
    }

    public SavedQueryFolderNode(@NotNull QueriesTreeContext context, @NotNull String projectPath) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/tfsIntegration/ui/SavedQueryFolderNode", "<init>"));
        }
        if (projectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectPath", "org/jetbrains/tfsIntegration/ui/SavedQueryFolderNode", "<init>"));
        }
        super(context);
        this.myQueryFolder = null;
        this.myProjectName = VersionControlPath.getTeamProject(projectPath);
    }

    protected void doUpdate() {
        PresentationData presentation = this.getPresentation();
        presentation.addText(this.getQueryFolderName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    @NotNull
    public Object[] getEqualityObjects() {
        Object[] objectArray = new Object[]{this.getQueryFolderName()};
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SavedQueryFolderNode", "getEqualityObjects"));
        }
        return objectArray;
    }

    public boolean isProject() {
        return this.myQueryFolder == null;
    }

    public SimpleNode[] getChildren() {
        ArrayList result = ContainerUtil.newArrayList();
        try {
            result.addAll(TfsUtil.forcePluginClassLoader(new ThrowableComputable<Collection<? extends SimpleNode>, VcsException>(){

                public Collection<? extends SimpleNode> compute() throws VcsException {
                    return SavedQueryFolderNode.this.getChildren(SavedQueryFolderNode.this.getQueryFolder());
                }
            }));
        }
        catch (VcsException e) {
            result.add(this.buildErrorNode((Exception)((Object)e)));
        }
        catch (ProxyException e) {
            result.add(this.buildErrorNode((Exception)((Object)e)));
        }
        return (SimpleNode[])ArrayUtil.toObjectArray((Collection)result, SimpleNode.class);
    }

    @NotNull
    private List<SimpleNode> getChildren(@NotNull QueryFolder folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "org/jetbrains/tfsIntegration/ui/SavedQueryFolderNode", "getChildren"));
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (QueryItem item : folder.getItems()) {
            BaseQueryNode child;
            if (item instanceof QueryDefinition) {
                child = new SavedQueryDefinitionNode(this.myQueriesTreeContext, (QueryDefinition)item);
            } else if (item instanceof QueryFolder) {
                child = new SavedQueryFolderNode(this.myQueriesTreeContext, (QueryFolder)item);
            } else {
                throw new IllegalArgumentException("Unknown query item " + item);
            }
            result.add(child);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SavedQueryFolderNode", "getChildren"));
        }
        return arrayList;
    }

    @NotNull
    private SimpleNode buildErrorNode(@NotNull Exception e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/tfsIntegration/ui/SavedQueryFolderNode", "buildErrorNode"));
        }
        TfsErrorTreeNode tfsErrorTreeNode = new TfsErrorTreeNode(this, e.getMessage());
        if (tfsErrorTreeNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SavedQueryFolderNode", "buildErrorNode"));
        }
        return tfsErrorTreeNode;
    }

    @NotNull
    private String getQueryFolderName() {
        String string = (String)ObjectUtils.assertNotNull((Object)(this.myQueryFolder != null ? this.myQueryFolder.getName() : this.myProjectName));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SavedQueryFolderNode", "getQueryFolderName"));
        }
        return string;
    }

    @NotNull
    private QueryFolder getQueryFolder() throws VcsException, ProxyException {
        QueryFolder result;
        if (this.myQueryFolder != null) {
            result = this.myQueryFolder;
        } else {
            Project project = this.getWorkItemClient().getProjects().get(this.myProjectName);
            if (project == null) {
                throw new VcsException("Could not find project " + this.myProjectName + " in " + this.getServer().getPresentableUri());
            }
            result = project.getQueryHierarchy();
        }
        QueryFolder queryFolder = result;
        if (queryFolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/SavedQueryFolderNode", "getQueryFolder"));
        }
        return queryFolder;
    }
}

