/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.tfsIntegration.core.TFSBundle;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkingFolderInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;
import org.jetbrains.tfsIntegration.ui.WorkspaceForm;

public class WorkspaceDialog
extends DialogWrapper {
    private final WorkspaceForm myForm;

    public WorkspaceDialog(Project project, @NotNull ServerInfo server) {
        if (server == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "server", "org/jetbrains/tfsIntegration/ui/WorkspaceDialog", "<init>"));
        }
        super(project, true);
        this.myForm = new WorkspaceForm(project, server);
        this.myForm.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WorkspaceDialog.this.revalidate();
            }
        });
        this.init();
        this.setTitle(TFSBundle.message("create.workspace.dialog.title", new Object[0]));
        this.setOKButtonText(TFSBundle.message("create.workspace.dialog.ok.button.text", new Object[0]));
        this.revalidate();
    }

    public WorkspaceDialog(Project project, @NotNull WorkspaceInfo workspace) {
        if (workspace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workspace", "org/jetbrains/tfsIntegration/ui/WorkspaceDialog", "<init>"));
        }
        super(project, true);
        this.myForm = new WorkspaceForm(project, workspace);
        this.myForm.addListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WorkspaceDialog.this.revalidate();
            }
        });
        this.init();
        this.setTitle(TFSBundle.message("edit.workspace.dialog.title", new Object[0]));
        this.setOKButtonText(TFSBundle.message("create.workspace.dialog.ok.button.text", new Object[0]));
        this.revalidate();
    }

    private void revalidate() {
        String errorMessage = this.getErrorMessage();
        this.setOKActionEnabled(errorMessage == null);
        this.myForm.setErrorMessage(errorMessage);
    }

    private String getErrorMessage() {
        String message = WorkspaceDialog.validate(this.myForm.getWorkspaceName());
        if (message == null) {
            message = this.myForm.validateWorkingFolders();
        }
        return message;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myForm.getPreferredFocusedComponent();
    }

    protected String getDimensionServiceKey() {
        return "TFS.ManageWorkspace";
    }

    protected JComponent createCenterPanel() {
        return this.myForm.getContentPane();
    }

    @Nullable
    private static String validate(String workspaceName) {
        if (StringUtil.isEmptyOrSpaces((String)workspaceName)) {
            return TFSBundle.message("workspace.name.empty", new Object[0]);
        }
        if (!WorkspaceInfo.isValidName(workspaceName)) {
            return TFSBundle.message("workspace.name.invalid", new Object[0]);
        }
        return null;
    }

    public String getWorkspaceName() {
        return this.myForm.getWorkspaceName();
    }

    @NotNull
    public WorkspaceInfo.Location getWorkspaceLocation() {
        WorkspaceInfo.Location location = this.myForm.getWorkspaceLocation();
        if (location == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/tfsIntegration/ui/WorkspaceDialog", "getWorkspaceLocation"));
        }
        return location;
    }

    public String getWorkspaceComment() {
        return this.myForm.getWorkspaceComment();
    }

    public List<WorkingFolderInfo> getWorkingFolders() {
        return this.myForm.getWorkingFolders();
    }

    protected String getHelpId() {
        return "project.propVCSSupport.VCSs.TFS.manage.connect.createWorkspace";
    }
}

